/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.model.Engine;
import com.lightcrafts.model.Scale;
import com.lightcrafts.ui.editor.ScaleListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ScaleModel {
    private static final Scale MinScale = new Scale(1, 40);
    private static final Scale MaxScale = new Scale(12, 1);
    private Engine engine;
    private ArrayList<Scale> scales;
    private int index;
    private Scale offScale;
    private LinkedList<ScaleListener> listeners;

    ScaleModel(Engine engine) {
        this(engine, new Scale(1, 1));
    }

    ScaleModel(Engine engine, Scale scale) {
        this.engine = engine;
        this.scales = new ArrayList(engine.getPreferredScales());
        Collections.sort(this.scales);
        this.listeners = new LinkedList();
        this.setScale(scale);
    }

    public List<Scale> getScales() {
        return new ArrayList<Scale>(this.scales);
    }

    public Scale getCurrentScale() {
        if (this.offScale != null) {
            return this.offScale;
        }
        return this.scales.get(this.index);
    }

    public boolean setScale(Scale scale) {
        if (scale.compareTo(MinScale) < 0 || scale.compareTo(MaxScale) > 0) {
            return false;
        }
        int i = this.getIndexOf(scale);
        if (i >= 0) {
            this.index = i;
            this.offScale = null;
        } else {
            this.offScale = scale;
        }
        this.engine.setScale(scale);
        this.notifyListeners();
        return true;
    }

    public void addScaleListener(ScaleListener listener) {
        this.listeners.add(listener);
    }

    public void removeScaleListener(ScaleListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        Scale scale = this.getCurrentScale();
        for (ScaleListener listener : this.listeners) {
            listener.scaleChanged(scale);
        }
    }

    public boolean scaleUp() {
        Scale scale = this.getNextScaleUp();
        return this.setScale(scale);
    }

    public boolean scaleDown() {
        Scale scale = this.getNextScaleDown();
        return this.setScale(scale);
    }

    boolean scaleBy(float percent) {
        Scale scale = this.getCurrentScale();
        float factor = scale.getFactor();
        scale = new Scale(factor *= percent);
        return this.setScale(scale);
    }

    private Scale getNextScaleUp() {
        Scale current = this.getCurrentScale();
        for (Scale next : this.scales) {
            if (next.compareTo(current) <= 0) continue;
            return next;
        }
        return null;
    }

    private Scale getNextScaleDown() {
        Scale current = this.getCurrentScale();
        for (int n = this.scales.size() - 1; n >= 0; --n) {
            Scale next = this.scales.get(n);
            if (next.compareTo(current) >= 0) continue;
            return next;
        }
        return null;
    }

    public boolean canScaleUp() {
        return this.getNextScaleUp() != null;
    }

    public boolean canScaleDown() {
        return this.getNextScaleDown() != null;
    }

    private int getIndexOf(Scale scale) {
        for (int n = 0; n < this.scales.size(); ++n) {
            Scale s = this.scales.get(n);
            if (!s.equals(scale)) continue;
            return n;
        }
        return -1;
    }
}

