/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.model.Engine;
import com.lightcrafts.ui.editor.XFormListener;
import java.awt.geom.AffineTransform;
import java.util.LinkedList;

class XFormModel {
    private Engine engine;
    private LinkedList<XFormListener> listeners;

    XFormModel(Engine engine) {
        this.engine = engine;
        this.listeners = new LinkedList();
    }

    void addXFormListener(XFormListener listener) {
        this.listeners.add(listener);
    }

    void removeXFormListener(XFormListener listener) {
        this.listeners.remove(listener);
    }

    void update() {
        this.notifyListeners(this.engine.getTransform());
    }

    private void notifyListeners(AffineTransform xform) {
        for (XFormListener listener : this.listeners) {
            listener.xFormChanged(xform);
        }
    }
}

