/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.export;

import com.lightcrafts.image.export.ColorProfileOption;
import com.lightcrafts.image.export.ImageExportOptions;
import com.lightcrafts.image.export.ImageFileExportOptions;
import com.lightcrafts.image.export.QualityOption;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.image.types.TIFFImageType;
import com.lightcrafts.model.RenderingIntent;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.export.ExportSizeFields;
import com.lightcrafts.ui.export.Locale;
import com.lightcrafts.ui.export.PpiField;
import com.lightcrafts.ui.toolkit.WidePopupComboBox;
import com.lightcrafts.utils.ColorProfileInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ExportControls
extends JPanel {
    private static Collection<ColorProfileInfo> Profiles = Platform.getPlatform().getExportProfiles();
    private static final Map<String, Integer> Sizes = new LinkedHashMap<String, Integer>();
    public static final int defaultSaveSize = 1024;
    private ImageFileExportOptions options;
    private int ctrlCount;

    public ExportControls(ImageExportOptions options, boolean textResize) {
        if (!(options instanceof ImageFileExportOptions)) {
            options = null;
        }
        this.options = (ImageFileExportOptions)options;
        if (options == null) {
            return;
        }
        this.setLayout(new GridBagLayout());
        this.addColorControl();
        if (textResize) {
            this.addTextSizeControl();
        } else {
            this.addMultiSizeControl();
        }
        ImageType type = options.getImageType();
        if (type instanceof JPEGImageType) {
            this.addRenderingIntentControl();
            this.addQualityControl();
            this.addPpiControl();
        }
        if (type instanceof TIFFImageType) {
            this.addRenderingIntentControl();
            this.addCompressionControl();
            this.addDepthControl();
            this.addPpiControl();
        }
    }

    private void addColorControl() {
        final WidePopupComboBox combo = new WidePopupComboBox();
        List<ColorProfileInfo> profiles = ColorProfileInfo.arrangeForMenu(Profiles);
        HashSet<String> names = new HashSet<String>();
        for (ColorProfileInfo info : profiles) {
            if (info != null) {
                String name = info.getName();
                combo.addItem(name);
                names.add(name);
                continue;
            }
            combo.addItem((Object)null);
        }
        ColorProfileOption defaultOption = this.options.colorProfile;
        String name = defaultOption.getValue();
        if (!names.contains(name)) {
            combo.addItem(name);
        }
        combo.setSelectedItem(name);
        combo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    String selected = (String)combo.getSelectedItem();
                    ((ExportControls)ExportControls.this).options.colorProfile.setValue(selected);
                }
            }
        });
        this.addLabelledControl(Locale.LOCALE.get("ColorProfileLabel"), combo);
    }

    private void addTextSizeControl() {
        ExportSizeFields fields = new ExportSizeFields(this.options);
        final JTextField xSize = fields.getXText();
        final JTextField ySize = fields.getYText();
        JButton reset = new JButton(Locale.LOCALE.get("ResetSizeButton"));
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int width = ((ExportControls)ExportControls.this).options.originalWidth.getValue();
                int height = ((ExportControls)ExportControls.this).options.originalHeight.getValue();
                xSize.setText(Integer.toString(width));
                ySize.setText(Integer.toString(height));
            }
        });
        Box controls = Box.createHorizontalBox();
        controls.add(xSize);
        controls.add(Box.createHorizontalStrut(6));
        controls.add(new JLabel("x"));
        controls.add(Box.createHorizontalStrut(6));
        controls.add(ySize);
        controls.add(Box.createHorizontalStrut(6));
        controls.add(new JLabel(Locale.LOCALE.get("PixelsLabel")));
        controls.add(Box.createHorizontalStrut(12));
        controls.add(Box.createHorizontalGlue());
        controls.add(reset);
        this.addLabelledControl(Locale.LOCALE.get("ResizeToLabel"), controls);
    }

    private void addMultiSizeControl() {
        JComboBox<String> sizes = new JComboBox<String>();
        for (String string : Sizes.keySet()) {
            sizes.addItem(string);
        }
        sizes.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    int size = (Integer)Sizes.get(e.getItem());
                    ((ExportControls)ExportControls.this).options.resizeWidth.setValue(size);
                    ((ExportControls)ExportControls.this).options.resizeHeight.setValue(size);
                }
            }
        });
        for (Map.Entry entry : Sizes.entrySet()) {
            int entrySize = (Integer)entry.getValue();
            if (this.options.resizeWidth.getValue() != entrySize) continue;
            String name = (String)entry.getKey();
            sizes.setSelectedItem(name);
            break;
        }
        sizes.setMaximumSize(sizes.getPreferredSize());
        Box controls = Box.createHorizontalBox();
        controls.add(sizes);
        controls.add(Box.createHorizontalGlue());
        this.addLabelledControl(Locale.LOCALE.get("ResizeToLabel"), controls);
    }

    private void addQualityControl() {
        int quality = ((JPEGImageType.ExportOptions)this.options).quality.getValue();
        final JLabel text = new JLabel("100");
        Dimension textSize = text.getPreferredSize();
        text.setHorizontalAlignment(4);
        text.setPreferredSize(textSize);
        final JSlider slider = new JSlider(0, 100);
        slider.setMajorTickSpacing(25);
        slider.setMinorTickSpacing(5);
        slider.setPaintTicks(true);
        slider.setValue(quality);
        text.setText(Integer.toString(quality));
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                int value = slider.getValue();
                QualityOption option = ((JPEGImageType.ExportOptions)((ExportControls)ExportControls.this).options).quality;
                option.setValue(value);
                text.setText(Integer.toString(value));
            }
        });
        Box textSlider = Box.createHorizontalBox();
        textSlider.add(slider);
        textSlider.add(Box.createHorizontalStrut(6));
        textSlider.add(text);
        this.addLabelledControl(Locale.LOCALE.get("QualityLabel"), textSlider);
    }

    private void addDepthControl() {
        final String bits8 = Locale.LOCALE.get("BitsPixel8");
        String bits16 = Locale.LOCALE.get("BitsPixel16");
        final JComboBox<String> combo = new JComboBox<String>();
        combo.addItem(bits8);
        combo.addItem(bits16);
        int value = 0;
        if (this.options instanceof TIFFImageType.ExportOptions) {
            value = ((TIFFImageType.ExportOptions)this.options).bitsPerChannel.getValue();
        }
        if (value == 8) {
            combo.setSelectedItem(bits8);
        }
        if (value == 16) {
            combo.setSelectedItem(bits16);
        }
        combo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    int bits;
                    Object selected = combo.getSelectedItem();
                    int n = bits = selected.equals(bits8) ? 8 : 16;
                    if (ExportControls.this.options instanceof TIFFImageType.ExportOptions) {
                        ((TIFFImageType.ExportOptions)((ExportControls)ExportControls.this).options).bitsPerChannel.setValue(bits);
                    }
                }
            }
        });
        this.addLabelledControl(Locale.LOCALE.get("BitDepthLabel"), combo);
    }

    private void addPpiControl() {
        PpiField ppi = new PpiField(this.options);
        Box controls = Box.createHorizontalBox();
        controls.add(ppi);
        controls.add(Box.createHorizontalGlue());
        this.addLabelledControl("Pixels per inch", controls);
    }

    private void addRenderingIntentControl() {
        RenderingIntent[] intents;
        WidePopupComboBox renderingIntent = new WidePopupComboBox();
        renderingIntent.setFocusable(false);
        for (RenderingIntent intent : intents = RenderingIntent.getAll()) {
            renderingIntent.addItem(intent);
        }
        int code = this.options.renderingIntent.getValue();
        boolean bpc = this.options.blackPointCompensation.getValue();
        RenderingIntent intent = ExportControls.convertIntToRenderingIntent(code, bpc);
        renderingIntent.setSelectedItem(intent);
        renderingIntent.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    WidePopupComboBox combo = (WidePopupComboBox)e.getSource();
                    RenderingIntent intent = (RenderingIntent)combo.getSelectedItem();
                    int code = ExportControls.convertRenderingIntentToInt(intent);
                    boolean bpc = ExportControls.convertRenderingIntentToBPC(intent);
                    ((ExportControls)ExportControls.this).options.renderingIntent.setValue(code);
                    ((ExportControls)ExportControls.this).options.blackPointCompensation.setValue(bpc);
                }
            }
        });
        this.addLabelledControl(Locale.LOCALE.get("RenderingIntentLabel"), renderingIntent);
    }

    private void addCompressionControl() {
        JCheckBox check = new JCheckBox("LZW");
        check.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                boolean selected;
                boolean bl = selected = event.getStateChange() == 1;
                if (ExportControls.this.options instanceof TIFFImageType.ExportOptions) {
                    ((TIFFImageType.ExportOptions)((ExportControls)ExportControls.this).options).lzwCompression.setValue(selected);
                }
            }
        });
        boolean selected = ((TIFFImageType.ExportOptions)this.options).lzwCompression.getValue();
        check.setSelected(selected);
        this.addLabelledControl(Locale.LOCALE.get("CompressionLabel"), check);
    }

    void addLabelledControl(String name, JComponent control) {
        this.addLabelledControl(name, control, true);
    }

    private void addLabelledControl(String name, JComponent control, boolean enabled) {
        JLabel label = new JLabel(name + ":");
        label.setHorizontalAlignment(4);
        Box ctrlBox = Box.createHorizontalBox();
        ctrlBox.add(control);
        ctrlBox.add(Box.createHorizontalGlue());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = this.ctrlCount++;
        constraints.ipadx = 2;
        constraints.ipady = 2;
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.anchor = 13;
        constraints.fill = 2;
        constraints.gridx = 0;
        this.add((Component)label, constraints);
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.gridx = 1;
        this.add((Component)ctrlBox, constraints);
        if (!enabled) {
            label.setEnabled(false);
            control.setEnabled(false);
        }
    }

    private static int convertRenderingIntentToInt(RenderingIntent intent) {
        if (intent == RenderingIntent.ABSOLUTE_COLORIMETRIC) {
            return 3;
        }
        if (intent == RenderingIntent.PERCEPTUAL) {
            return 0;
        }
        if (intent == RenderingIntent.RELATIVE_COLORIMETRIC) {
            return 1;
        }
        if (intent == RenderingIntent.RELATIVE_COLORIMETRIC_BP) {
            return 1;
        }
        if (intent == RenderingIntent.SATURATION) {
            return 2;
        }
        return 0;
    }

    private static boolean convertRenderingIntentToBPC(RenderingIntent intent) {
        return intent == RenderingIntent.RELATIVE_COLORIMETRIC_BP;
    }

    private static RenderingIntent convertIntToRenderingIntent(int code, boolean bpc) {
        RenderingIntent intent;
        switch (code) {
            case 3: {
                intent = RenderingIntent.ABSOLUTE_COLORIMETRIC;
                break;
            }
            case 0: {
                intent = RenderingIntent.PERCEPTUAL;
                break;
            }
            case 1: {
                if (bpc) {
                    intent = RenderingIntent.RELATIVE_COLORIMETRIC_BP;
                    break;
                }
                intent = RenderingIntent.RELATIVE_COLORIMETRIC;
                break;
            }
            case 2: {
                intent = RenderingIntent.SATURATION;
                break;
            }
            default: {
                intent = RenderingIntent.PERCEPTUAL;
            }
        }
        return intent;
    }

    static {
        Sizes.put("Fit within 1024 x 1024", 1024);
        Sizes.put("Fit within 1536 x 1536", 1536);
        Sizes.put("Fit within 2048 x 2048", 2048);
        Sizes.put("Fit within 2560 x 2560", 2560);
        Sizes.put("Don't limit", 0);
    }
}

