/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.export;

import com.lightcrafts.image.export.ImageFileExportOptions;
import com.lightcrafts.image.export.ResolutionOption;
import com.lightcrafts.ui.LightZoneSkin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

class PpiField
extends JTextField {
    ResolutionOption resolution;
    private static final FocusListener FocusSelector = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent event) {
            JTextField text = (JTextField)event.getSource();
            text.selectAll();
        }
    };
    private static final ActionListener UpAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            final JTextField source = (JTextField)event.getSource();
            InputVerifier verifier = source.getInputVerifier();
            if (!verifier.verify(source)) {
                return;
            }
            final int number = Integer.parseInt(source.getText());
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    source.setText(Integer.toString(number + 1));
                }
            });
        }
    };
    private static final ActionListener DownAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            final JTextField source = (JTextField)event.getSource();
            InputVerifier verifier = source.getInputVerifier();
            if (!verifier.verify(source)) {
                return;
            }
            final int number = Integer.parseInt(source.getText());
            if (number > 1) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        source.setText(Integer.toString(number - 1));
                    }
                });
            }
        }
    };
    private static final InputVerifier Verifier = new InputVerifier(){

        @Override
        public boolean verify(JComponent input) {
            double x;
            String text = ((JTextField)input).getText();
            try {
                x = Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return x > 0.0;
        }
    };
    private final DocumentListener TextUpdater = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.handleDocumentChange();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.handleDocumentChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.handleDocumentChange();
        }

        private void handleDocumentChange() {
            InputVerifier verifier = PpiField.this.getInputVerifier();
            boolean verified = verifier.verify(PpiField.this);
            if (!verified) {
                PpiField.this.setForeground(Color.red);
            } else {
                PpiField.this.setForeground(LightZoneSkin.Colors.ToolPanesForeground);
                int value = Integer.parseInt(PpiField.this.getText());
                PpiField.this.resolution.setValue(value);
            }
        }
    };

    PpiField(ImageFileExportOptions options) {
        super(4);
        this.resolution = options.resolution;
        int ppi = this.resolution.getValue();
        this.setText(Integer.toString(ppi));
        this.setInputVerifier(Verifier);
        this.setHorizontalAlignment(4);
        this.addFocusListener(FocusSelector);
        this.registerKeyboardAction(UpAction, "Increment", KeyStroke.getKeyStroke(38, 0), 0);
        this.registerKeyboardAction(DownAction, "Decrement", KeyStroke.getKeyStroke(40, 0), 0);
        Document doc = this.getDocument();
        doc.addDocumentListener(this.TextUpdater);
        Dimension size = this.getPreferredSize();
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this.setMaximumSize(size);
    }
}

