/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.layout;

import com.lightcrafts.ui.LightZoneSkin;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class ToggleTitleBorder
extends CompoundBorder
implements PreferenceChangeListener {
    private static final Preferences Prefs = Preferences.userRoot().node("/com/lightcrafts/ui/layout");
    private static final String ShowBordersKey = "ShowToggleTitleBorders";
    private static final RenderingHints aliasingRenderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private JComponent comp;
    private LZTitleBorder title;
    private PlaceholderBorder placeholder;
    private Border original;

    public static void setBorder(JComponent comp, String title) {
        ToggleTitleBorder border = new ToggleTitleBorder(comp, title);
        Prefs.addPreferenceChangeListener(border);
        comp.setBorder(border);
    }

    public static void unsetBorder(JComponent comp) {
        Border border = comp.getBorder();
        if (border instanceof ToggleTitleBorder) {
            ToggleTitleBorder ttborder = (ToggleTitleBorder)border;
            Prefs.removePreferenceChangeListener(ttborder);
            comp.setBorder(ttborder.original);
        }
    }

    public static void unsetAllBorders(JComponent comp) {
        Component[] children;
        ToggleTitleBorder.unsetBorder(comp);
        for (Component child : children = comp.getComponents()) {
            if (!(child instanceof JComponent)) continue;
            ToggleTitleBorder.unsetAllBorders((JComponent)child);
        }
    }

    public static void setShowBorders(boolean show) {
        Prefs.putBoolean(ShowBordersKey, show);
    }

    public static boolean isShowBorders() {
        return Prefs.getBoolean(ShowBordersKey, true);
    }

    private ToggleTitleBorder(JComponent comp, String text) {
        this.comp = comp;
        this.title = new LZTitleBorder(this, text);
        this.title.setTitleJustification(2);
        this.title.setTitlePosition(5);
        Insets insets = this.getBorderInsets(comp);
        insets.top = 0;
        insets.bottom = 0;
        this.placeholder = new PlaceholderBorder(this, insets);
        this.insideBorder = this.original = comp.getBorder();
        this.outsideBorder = ToggleTitleBorder.isShowBorders() ? this.title : this.placeholder;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        boolean show = ToggleTitleBorder.isShowBorders();
        this.outsideBorder = show ? this.title : this.placeholder;
        this.comp.revalidate();
        this.comp.repaint();
    }

    static {
        aliasingRenderHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        aliasingRenderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    static class LZTitleBorder
    extends TitledBorder {
        ToggleTitleBorder ttb;

        LZTitleBorder(ToggleTitleBorder ttb, String title) {
            super(BorderFactory.createEmptyBorder(), title);
            this.ttb = ttb;
            this.titleColor = LightZoneSkin.Colors.LabelForeground;
        }

        @Override
        public void paintBorder(Component jComponent, Graphics graphics, int x, int y, int width, int height) {
            Graphics2D g = (Graphics2D)graphics;
            g.setRenderingHints(aliasingRenderHints);
            super.paintBorder(jComponent, graphics, x, y, width, height);
        }
    }

    static class PlaceholderBorder
    extends EmptyBorder {
        ToggleTitleBorder ttb;

        PlaceholderBorder(ToggleTitleBorder ttb, Insets insets) {
            super(insets);
            this.ttb = ttb;
        }
    }
}

