/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.metadata;

import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.ui.metadata.DirectoryStack;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class InfoPane
extends JScrollPane {
    private DirectoryStack dirs;

    public InfoPane(ImageMetadata meta) {
        this();
        this.setOpaque(true);
        this.getViewport().setOpaque(false);
        this.setVerticalScrollBarPolicy(20);
        this.setHorizontalScrollBarPolicy(31);
        this.setMetadata(meta);
    }

    public InfoPane() {
        this.setOpaque(true);
        this.getViewport().setOpaque(false);
        this.setVerticalScrollBarPolicy(20);
        this.setHorizontalScrollBarPolicy(31);
        this.setPlaceholder();
    }

    public void setMetadata(ImageMetadata meta) {
        if (meta != null) {
            if (this.dirs != null) {
                this.dirs.setMetadata(meta);
            } else {
                this.dirs = new DirectoryStack(meta);
            }
            this.getViewport().add(this.dirs);
        } else {
            this.getViewport().removeAll();
            this.setPlaceholder();
        }
    }

    public void dispose() {
        if (this.dirs != null) {
            this.dirs.disposeTables();
        }
    }

    private void setPlaceholder() {
        JPanel placeholder = new JPanel();
        placeholder.setPreferredSize(new Dimension(1, 1));
        this.getViewport().setView(placeholder);
    }
}

