/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.metadata;

import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.ui.ExceptionDisplay;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.net.URL;
import javax.swing.JPanel;

public class PreviewComponent
extends JPanel {
    private static Image SadSmiley;
    private static Dimension SadSize;
    private ExceptionDisplay ex;
    private RenderedImage image;

    public PreviewComponent(ImageInfo info) {
        this.setOpaque(false);
        Throwable t = null;
        try {
            this.image = info.getPreviewImage();
        }
        catch (Throwable e) {
            t = e;
        }
        if (t != null) {
            this.setLayout(new BorderLayout());
            this.ex = new ExceptionDisplay(t);
            this.add(this.ex);
        }
        this.setOpaque(false);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.image != null) {
            return new Dimension(this.image.getWidth(), this.image.getHeight());
        }
        if (this.ex != null) {
            return super.getPreferredSize();
        }
        return SadSize;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.image != null) {
            g2d.drawRenderedImage(this.image, new AffineTransform());
        } else if (this.ex == null) {
            g.drawImage(SadSmiley, 0, 0, this);
        }
    }

    static {
        SadSize = new Dimension(98, 98);
        URL url = PreviewComponent.class.getResource("resources/sadSmiley.jpg");
        SadSmiley = Toolkit.getDefaultToolkit().createImage(url);
    }
}

