/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.mode;

import com.lightcrafts.ui.mode.AbstractMode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

public class LineMode
extends AbstractMode {
    private static Cursor Crosshair = new Cursor(1);
    private static Stroke BlackStroke;
    private static Stroke WhiteStroke;
    private Line2D line;
    private JComponent overlay = new LineOverlay();

    public LineMode() {
        this.overlay.setCursor(Crosshair);
        LineListener listener = new LineListener();
        this.overlay.addMouseListener(listener);
        this.overlay.addMouseMotionListener(listener);
    }

    public Line2D getLine() {
        return this.line;
    }

    @Override
    public JComponent getOverlay() {
        return this.overlay;
    }

    @Override
    public void addMouseInputListener(MouseInputListener listener) {
        this.overlay.addMouseListener(listener);
        this.overlay.addMouseMotionListener(listener);
    }

    @Override
    public void removeMouseInputListener(MouseInputListener listener) {
        this.overlay.removeMouseListener(listener);
        this.overlay.removeMouseMotionListener(listener);
    }

    @Override
    public boolean wantsAutocroll() {
        return true;
    }

    static {
        float[] dash = new float[]{5.0f, 5.0f};
        float width = 1.0f;
        BlackStroke = new BasicStroke(1.0f, 2, 0, 1.0f, dash, 0.0f);
        WhiteStroke = new BasicStroke(1.0f, 2, 0, 1.0f, dash, 5.0f);
    }

    private class LineListener
    extends MouseInputAdapter {
        private Point start;

        private LineListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.start = e.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.start = null;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point end = e.getPoint();
            LineMode.this.line = new Line2D.Float(this.start.x, this.start.y, end.x, end.y);
            LineMode.this.overlay.repaint();
        }
    }

    private class LineOverlay
    extends JComponent {
        private LineOverlay() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (LineMode.this.line != null) {
                Graphics2D g = (Graphics2D)graphics;
                g.setStroke(WhiteStroke);
                g.setColor(Color.white);
                g.draw(LineMode.this.line);
                g.setStroke(BlackStroke);
                g.setColor(Color.black);
                g.draw(LineMode.this.line);
            }
        }
    }
}

