/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.mode;

import com.lightcrafts.ui.mode.Mode;
import com.lightcrafts.ui.mode.NoMode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.LinkedList;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public class ModeOverlay
extends JLayeredPane {
    private static final Integer UnderlayLayer = 0;
    private Integer OverlayLayer = 1;
    private Component underlay;
    private Stack<Mode> modes;
    private MouseMotionListener autoscroller;
    private Collection<MouseInputListener> mouseListeners;
    private static final double UnderlayBorder = 0.025;
    private Dimension underlaySize;
    private Dimension size;

    public ModeOverlay(Component underlay) {
        this.underlay = underlay;
        this.modes = new Stack();
        this.mouseListeners = new LinkedList<MouseInputListener>();
        this.setLayout(null);
        this.add(underlay, UnderlayLayer);
        this.autoscroller = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Rectangle r = new Rectangle(e.getX(), e.getY(), 1, 1);
                ModeOverlay.this.scrollRectToVisible(r);
            }
        };
        this.pushMode(new NoMode());
    }

    public Mode peekMode() {
        try {
            return this.modes.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public Mode popMode() {
        try {
            Mode oldMode = this.modes.pop();
            if (oldMode != null) {
                this.removeMode(oldMode);
                this.decLayer();
                this.repaint();
            }
            return oldMode;
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public void pushMode(Mode mode) {
        this.modes.push(mode);
        this.incLayer();
        this.addMode(mode);
        this.validate();
    }

    public void addMouseInputListener(MouseInputListener listener) {
        Component[] comps;
        for (Component comp : comps = this.getComponents()) {
            comp.addMouseListener(listener);
            comp.addMouseMotionListener(listener);
        }
        this.mouseListeners.add(listener);
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    public void removeMouseInputListener(MouseInputListener listener) {
        Component[] comps;
        for (Component comp : comps = this.getComponents()) {
            comp.removeMouseListener(listener);
            comp.removeMouseMotionListener(listener);
        }
        this.mouseListeners.remove(listener);
        this.removeMouseListener(listener);
        this.removeMouseMotionListener(listener);
    }

    private void incLayer() {
        int i = this.OverlayLayer;
        this.OverlayLayer = ++i;
    }

    private void decLayer() {
        int i = this.OverlayLayer;
        this.OverlayLayer = --i;
    }

    private void addMode(Mode mode) {
        JComponent overlay = mode.getOverlay();
        overlay.setOpaque(false);
        if (mode.wantsAutocroll()) {
            overlay.setAutoscrolls(true);
            overlay.addMouseMotionListener(this.autoscroller);
        }
        this.add((Component)overlay, this.OverlayLayer);
        for (MouseInputListener listener : this.mouseListeners) {
            mode.addMouseInputListener(listener);
        }
    }

    private void removeMode(Mode mode) {
        JComponent overlay = mode.getOverlay();
        this.remove(overlay);
        overlay.removeMouseMotionListener(this.autoscroller);
        for (MouseInputListener listener : this.mouseListeners) {
            mode.removeMouseInputListener(listener);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension underlaySize = this.underlay.getPreferredSize();
        Rectangle underlayRect = new Rectangle(0, 0, underlaySize.width, underlaySize.height);
        underlayRect = ModeOverlay.outsetPercent(underlayRect);
        Dimension viewportSize = this.getViewportSize();
        if (viewportSize != null) {
            int w = Math.max(underlayRect.width, viewportSize.width);
            int h = Math.max(underlayRect.height, viewportSize.height);
            return new Dimension(w, h);
        }
        return underlaySize;
    }

    public static Rectangle outsetPercent(Rectangle rect) {
        double w = rect.width;
        double h = rect.height;
        double wp = 1.025 * w + 0.025 * h;
        double hp = 0.025 * w + 1.025 * h;
        double cx = rect.x + rect.width / 2;
        double cy = rect.x + rect.width / 2;
        return new Rectangle((int)Math.round(cx - wp / 2.0), (int)Math.round(cy - hp / 2.0), (int)Math.round(wp), (int)Math.round(hp));
    }

    public static Rectangle insetPercent(Rectangle rect) {
        double c = 0.9523809523809523;
        double wp = rect.width;
        double hp = rect.height;
        double w = c * (1.025 * wp - 0.025 * hp);
        double h = c * (-0.025 * wp + 1.025 * hp);
        double cx = rect.x + rect.width / 2;
        double cy = rect.x + rect.width / 2;
        return new Rectangle((int)Math.round(cx - w / 2.0), (int)Math.round(cy - h / 2.0), (int)Math.round(w), (int)Math.round(h));
    }

    public AffineTransform getTransform() {
        this.doUnderlayLayout();
        Point loc = this.underlay.getLocation();
        return AffineTransform.getTranslateInstance(loc.x, loc.y);
    }

    @Override
    public void doLayout() {
        Component[] comps;
        this.doUnderlayLayout();
        Dimension size = this.getSize();
        for (Component comp : comps = this.getComponents()) {
            if (comp == this.underlay) continue;
            comp.setLocation(0, 0);
            comp.setSize(size);
        }
    }

    private void doUnderlayLayout() {
        Dimension size;
        Dimension underlaySize = this.underlay.getPreferredSize();
        this.size = size = this.getSize();
        this.underlaySize = underlaySize;
        int centerX = size.width / 2;
        int centerY = size.height / 2;
        int x = centerX - underlaySize.width / 2;
        int y = centerY - underlaySize.height / 2;
        this.underlay.setLocation(x, y);
        this.underlay.setSize(underlaySize);
    }

    private Dimension getViewportSize() {
        JViewport viewport = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this);
        if (viewport != null) {
            return viewport.getSize();
        }
        return null;
    }
}

