/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation;

import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.model.Operation;
import com.lightcrafts.model.RGBColorSelection;
import com.lightcrafts.model.RGBColorSelectionPreset;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.editor.EditorMode;
import com.lightcrafts.ui.mode.DropperMode;
import com.lightcrafts.ui.operation.Locale;
import com.lightcrafts.ui.operation.OpControl;
import com.lightcrafts.ui.operation.ResetColorSelectionButton;
import com.lightcrafts.ui.swing.ColorSwatch;
import com.lightcrafts.ui.swing.RangeSelector;
import com.lightcrafts.ui.swing.RangeSelectorZoneTrack;
import com.lightcrafts.ui.toolkit.DropperButton;
import com.lightcrafts.ui.toolkit.LCSliderUI;
import com.lightcrafts.utils.LCMS;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.AbstractUndoableEdit;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.theme.SubstanceTheme;

final class ColorSelectionControls
extends Box {
    private final PropertyChangeSupport pcs;
    public static final String COLOR_SELECTION = "Color Selection";
    private static LCMS.Transform ts = new LCMS.Transform(new LCMS.Profile(JAIContext.linearProfile), LCMS.TYPE_RGB_8, new LCMS.Profile(JAIContext.systemProfile), LCMS.TYPE_RGB_8, 0, 0);
    private boolean m_skipSelectPresetCode;
    private final ColorSwatch m_colorSwatch;
    private final JSlider m_colorRangeSlider;
    private final ColorPresets m_colorPresets;
    private ColorSelectionEdit m_currentEdit;
    private DropperButton m_dropperButton;
    private DropperMode m_dropperMode;
    private final JCheckBox m_invertSelection;
    private Operation m_op;
    private final RangeSelector m_luminositySelector;
    private float m_lowerLuminosityFeather;
    private float m_upperLuminosityFeather;
    private RGBColorSelection m_prevCS;
    private JCheckBox m_hueEnabled;
    private JCheckBox m_luminosityEnabled;
    private boolean m_isDropperModeCancelling;
    private boolean m_isUpdatingControls;
    private OpControl.OpControlUndoSupport m_undoSupport;
    private static final String ColorSelectStartToolTip = Locale.LOCALE.get("ColorSelectStartToolTip");
    private static final String ColorSelectEndToolTip = Locale.LOCALE.get("ColorSelectEndToolTip");
    private static final String ColorSelectionKey = "ColorSelection";
    private static final String HueRedKey = "HueRed";
    private static final String HueGreenKey = "HueGreen";
    private static final String HueBlueKey = "HueBlue";
    private static final String HueRadiusKey = "HueRadius";
    private static final String HueEnabledKey = "HueEnabled";
    private static final String LuminosityLowerKey = "LuminosityLower";
    private static final String LuminosityUpperKey = "LuminosityUpper";
    private static final String LuminosityLowerFeatherKey = "LuminosityLowerFeather";
    private static final String LuminosityUpperFeatherKey = "LuminosityUpperFeather";
    private static final String LuminosityEnabledKey = "LuminosityEnabled";
    private static final String InvertedKey = "Inverted";
    private static final int SLIDER_RADIUS_MIN = 0;
    private static final int SLIDER_RADIUS_MAX = 100;
    private static final int SELECTOR_LUMINOSITY_MIN = 0;
    private static final int SELECTOR_LUMINOSITY_MAX = 1000;
    private static final Color COLOR_SWATCH_DEFAULT = Color.GRAY;
    private static final int COLOR_RADIUS_DEFAULT = 20;

    public static JRadioButton getSelection(ButtonGroup group) {
        Enumeration<AbstractButton> e = group.getElements();
        while (e.hasMoreElements()) {
            JRadioButton b = (JRadioButton)e.nextElement();
            if (b.getModel() != group.getSelection()) continue;
            return b;
        }
        return null;
    }

    ColorSelectionControls(OpControl control, PropertyChangeSupport pcs) {
        super(0);
        this.pcs = pcs;
        this.m_op = control.getOperation();
        this.m_undoSupport = control.undoSupport;
        this.m_hueEnabled = new JCheckBox();
        this.m_hueEnabled.setFocusable(false);
        this.m_hueEnabled.setSelected(true);
        this.m_hueEnabled.setToolTipText(Locale.LOCALE.get("HueDisableToolTip"));
        this.m_hueEnabled.addItemListener(new EnablerListener(Locale.LOCALE.get("HueDisableToolTip"), Locale.LOCALE.get("HueEnableToolTip")));
        this.m_luminosityEnabled = new JCheckBox();
        this.m_luminosityEnabled.setFocusable(false);
        this.m_luminosityEnabled.setSelected(true);
        this.m_luminosityEnabled.setToolTipText(Locale.LOCALE.get("BrightnessDisableToolTip"));
        this.m_luminosityEnabled.addItemListener(new EnablerListener(Locale.LOCALE.get("BrightnessDisableToolTip"), Locale.LOCALE.get("BrightnessEnableToolTip")));
        LocalListener localListener = new LocalListener();
        this.m_colorSwatch = new ColorSwatch(COLOR_SWATCH_DEFAULT);
        JLabel colorRadiusLabel = new JLabel(Locale.LOCALE.get("ColorRangeLabel") + ':');
        colorRadiusLabel.setBackground(OpControl.Background);
        colorRadiusLabel.setFocusable(false);
        colorRadiusLabel.setFont(LightZoneSkin.fontSet.getSmallFont());
        this.m_colorRangeSlider = new JSlider(0, 100, 20);
        this.m_colorRangeSlider.setBackground(OpControl.Background);
        this.m_colorRangeSlider.setFocusable(false);
        this.m_colorRangeSlider.setUI(new LCSliderUI(this.m_colorRangeSlider));
        this.m_colorRangeSlider.setToolTipText(Locale.LOCALE.get("ColorRangeToolTip"));
        this.m_colorRangeSlider.addChangeListener(localListener);
        this.m_colorRangeSlider.addMouseListener(localListener);
        this.m_colorPresets = new ColorPresets();
        this.m_luminositySelector = new RangeSelector(0, 1000);
        this.m_luminositySelector.setTrack(new RangeSelectorZoneTrack());
        this.m_luminositySelector.addChangeListener(localListener);
        this.m_luminositySelector.addMouseListener(localListener);
        this.m_luminositySelector.setToolTipText(Locale.LOCALE.get("BrightnessSelectorToolTip"));
        this.initDropper(control);
        this.m_invertSelection = new JCheckBox("Invert");
        this.m_invertSelection.setFont(LightZoneSkin.fontSet.getSmallFont());
        this.m_invertSelection.setFocusable(false);
        this.m_invertSelection.setToolTipText(Locale.LOCALE.get("InvertColorSelectionEnableToolTip"));
        this.m_invertSelection.addItemListener(new EnablerListener(Locale.LOCALE.get("InvertColorSelectionDisableToolTip"), Locale.LOCALE.get("InvertColorSelectionEnableToolTip"), Locale.LOCALE.get("InvertColorSelectionEditName"), Locale.LOCALE.get("NormalColorSelectionEditName")));
        ResetColorSelectionButton resetButton = new ResetColorSelectionButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ColorSelectionControls.this.resetColorSelection();
            }
        });
        this.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        JPanel presets = new JPanel();
        presets.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        presets.setLayout(new BoxLayout(presets, 0));
        presets.add(Box.createHorizontalStrut(10));
        presets.add(this.m_colorPresets);
        presets.add(Box.createHorizontalGlue());
        JPanel radius = new JPanel();
        radius.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        radius.setLayout(new BoxLayout(radius, 0));
        radius.add(Box.createHorizontalStrut(5));
        radius.add(colorRadiusLabel);
        radius.add(this.m_colorRangeSlider);
        JPanel presetsAndRadius = new JPanel();
        presetsAndRadius.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        presetsAndRadius.setLayout(new BoxLayout(presetsAndRadius, 1));
        presetsAndRadius.add(Box.createVerticalStrut(10));
        presetsAndRadius.add(presets);
        presetsAndRadius.add(radius);
        JPanel colorControls = new JPanel();
        colorControls.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        colorControls.setLayout(new BoxLayout(colorControls, 0));
        colorControls.add(this.m_hueEnabled);
        colorControls.add(this.m_colorSwatch);
        colorControls.add(presetsAndRadius);
        JPanel luminosityControls = new JPanel();
        luminosityControls.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        luminosityControls.setLayout(new BoxLayout(luminosityControls, 0));
        luminosityControls.add(this.m_luminosityEnabled);
        luminosityControls.add(this.m_luminositySelector);
        JPanel colorAndLuminosity = new JPanel();
        colorAndLuminosity.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        colorAndLuminosity.setLayout(new BoxLayout(colorAndLuminosity, 1));
        colorAndLuminosity.add(colorControls);
        colorAndLuminosity.add(luminosityControls);
        JPanel resetAndDropper = new JPanel();
        resetAndDropper.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        resetAndDropper.setLayout(new BoxLayout(resetAndDropper, 0));
        resetAndDropper.add(this.m_dropperButton);
        resetAndDropper.add(resetButton);
        JPanel invertEtc = new JPanel();
        invertEtc.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        invertEtc.setLayout(new BoxLayout(invertEtc, 1));
        invertEtc.add(Box.createVerticalGlue());
        invertEtc.add(resetAndDropper);
        invertEtc.add(Box.createVerticalStrut(8));
        invertEtc.add(this.m_invertSelection);
        this.m_invertSelection.setAlignmentX(0.0f);
        resetAndDropper.setAlignmentX(0.0f);
        this.add(invertEtc);
        this.add(Box.createHorizontalStrut(4));
        this.add(colorAndLuminosity);
        this.add(Box.createHorizontalGlue());
        this.m_currentEdit = new ColorSelectionEdit();
    }

    void operationChanged(Operation op) {
        this.m_op = op;
    }

    void save(XmlNode node) {
        RGBColorSelection cs = this.m_op.getColorSelection();
        XmlNode colorNode = node.addChild(ColorSelectionKey);
        colorNode.setAttribute(HueRedKey, Float.toString(cs.red));
        colorNode.setAttribute(HueGreenKey, Float.toString(cs.green));
        colorNode.setAttribute(HueBlueKey, Float.toString(cs.blue));
        colorNode.setAttribute(HueRadiusKey, Float.toString(cs.radius));
        colorNode.setAttribute(HueEnabledKey, Boolean.toString(cs.isColorEnabled));
        colorNode.setAttribute(LuminosityLowerKey, Float.toString(cs.luminosityLower));
        colorNode.setAttribute(LuminosityLowerFeatherKey, Float.toString(cs.luminosityLowerFeather));
        colorNode.setAttribute(LuminosityUpperKey, Float.toString(cs.luminosityUpper));
        colorNode.setAttribute(LuminosityUpperFeatherKey, Float.toString(cs.luminosityUpperFeather));
        colorNode.setAttribute(LuminosityEnabledKey, Boolean.toString(cs.isLuminosityEnabled));
        colorNode.setAttribute(InvertedKey, Boolean.toString(cs.isInverted));
    }

    void restore(XmlNode node) throws XMLException {
        if (node.hasChild(ColorSelectionKey)) {
            node = node.getChild(ColorSelectionKey);
            try {
                float red = Float.parseFloat(node.getAttribute(HueRedKey));
                float green = Float.parseFloat(node.getAttribute(HueGreenKey));
                float blue = Float.parseFloat(node.getAttribute(HueBlueKey));
                float radius = Float.parseFloat(node.getAttribute(HueRadiusKey));
                boolean isHueEnabled = Boolean.parseBoolean(node.getAttribute(HueEnabledKey));
                float blv = Float.parseFloat(node.getAttribute(LuminosityLowerKey));
                float blfv = Float.parseFloat(node.getAttribute(LuminosityLowerFeatherKey));
                float buv = Float.parseFloat(node.getAttribute(LuminosityUpperKey));
                float bufv = Float.parseFloat(node.getAttribute(LuminosityUpperFeatherKey));
                boolean isLuminosityEnabled = Boolean.parseBoolean(node.getAttribute(LuminosityEnabledKey));
                boolean isInverted = Boolean.parseBoolean(node.getAttribute(InvertedKey));
                RGBColorSelection cs = new RGBColorSelection(red, green, blue, radius, blv, blfv, buv, bufv, isInverted, isHueEnabled, isLuminosityEnabled);
                this.colorSelectionToControls(cs, false);
                this.m_op.setColorSelection(cs);
                this.m_currentEdit = new ColorSelectionEdit();
            }
            catch (IllegalArgumentException e) {
                throw new XMLException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void colorSelectionToControls(RGBColorSelection cs, boolean force) {
        this.m_isUpdatingControls = true;
        try {
            if (this.m_hueEnabled.isSelected() && cs.isColorEnabled || force) {
                this.m_colorSwatch.setColor(cs.toColor());
                int radius = cs.getPreset() == RGBColorSelectionPreset.AllColors ? 20 : (int)(cs.radius * 100.0f);
                this.m_colorRangeSlider.setValue(radius);
                this.m_hueEnabled.setSelected(cs.isColorEnabled);
            }
            if (this.m_luminosityEnabled.isSelected() && cs.isLuminosityEnabled || force) {
                float cblv = cs.luminosityLower;
                float cblfv = cs.luminosityLowerFeather;
                float cbuv = cs.luminosityUpper;
                float cbufv = cs.luminosityUpperFeather;
                int bMin = this.m_luminositySelector.getMinimumThumbValue();
                int bMax = this.m_luminositySelector.getMaximumThumbValue();
                int bWidth = bMax - bMin;
                this.m_luminositySelector.setProperties(bMin, bMax, (int)(cblv * (float)bWidth), (int)((cblv - cblfv) * (float)bWidth), (int)(cbuv * (float)bWidth), (int)((cbuv + cbufv) * (float)bWidth), this.m_luminositySelector.getMinimumTrackValue(), this.m_luminositySelector.getMaximumTrackValue(), this.m_luminositySelector.getTrackValue(), this.m_luminositySelector.getTrackValueWraps());
                this.m_luminosityEnabled.setSelected(cs.isLuminosityEnabled);
            }
            this.m_invertSelection.setSelected(cs.isInverted);
            this.m_skipSelectPresetCode = true;
            this.m_colorPresets.setSelectedItem(cs.getPreset());
            this.m_skipSelectPresetCode = false;
            if (cs.isAllSelected()) {
                this.pcs.firePropertyChange(COLOR_SELECTION, Boolean.TRUE, Boolean.FALSE);
            } else {
                this.pcs.firePropertyChange(COLOR_SELECTION, Boolean.FALSE, Boolean.TRUE);
            }
        }
        finally {
            this.m_isUpdatingControls = false;
        }
    }

    private RGBColorSelection controlsToColorSelection() {
        Color c = this.m_colorSwatch.getColor();
        int hMin = this.m_colorRangeSlider.getMinimum();
        int hMax = this.m_colorRangeSlider.getMaximum();
        float hWidth = hMax - hMin;
        float radius = this.m_colorPresets.getSelectedItem() == RGBColorSelectionPreset.AllColors ? -1.0f : (float)this.m_colorRangeSlider.getValue() / hWidth;
        int lMin = this.m_luminositySelector.getMinimumThumbValue();
        int lMax = this.m_luminositySelector.getMaximumThumbValue();
        float lWidth = lMax - lMin;
        int llv = this.m_luminositySelector.getLowerThumbValue();
        int llfv = this.m_luminositySelector.getLowerThumbFeatheringValue();
        int luv = this.m_luminositySelector.getUpperThumbValue();
        int lufv = this.m_luminositySelector.getUpperThumbFeatheringValue();
        float cllv = (float)llv / lWidth;
        float cllfv = (float)(llv - llfv) / lWidth;
        float cluv = (float)luv / lWidth;
        float clufv = (float)(lufv - luv) / lWidth;
        RGBColorSelection cs = new RGBColorSelection((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, radius, cllv, cllfv, cluv, clufv, this.m_invertSelection.isSelected(), this.m_hueEnabled.isSelected(), this.m_luminosityEnabled.isSelected());
        if (cs.isAllSelected()) {
            this.pcs.firePropertyChange(COLOR_SELECTION, Boolean.TRUE, Boolean.FALSE);
        } else {
            this.pcs.firePropertyChange(COLOR_SELECTION, Boolean.FALSE, Boolean.TRUE);
        }
        return cs;
    }

    public ComboFrame getComboFrame() {
        return (ComboFrame)SwingUtilities.getAncestorOfClass(ComboFrame.class, this);
    }

    private void initDropper(final OpControl control) {
        this.m_dropperButton = new DropperButton();
        this.m_dropperButton.setToolTips(ColorSelectStartToolTip, ColorSelectEndToolTip);
        this.m_dropperButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    ColorSelectionControls.this.getComboFrame().getEditor().setMode(EditorMode.ARROW);
                    control.notifyListenersEnterMode(ColorSelectionControls.this.m_dropperMode);
                } else if (!ColorSelectionControls.this.m_isDropperModeCancelling) {
                    control.notifyListenersExitMode(ColorSelectionControls.this.m_dropperMode);
                }
            }
        });
        this.m_dropperMode = new DropperMode(control);
        this.m_dropperMode.addListener(new DropperMode.Listener(){

            @Override
            public void pointSelected(Point2D p) {
                ColorSelectionControls.this.selectColorAt(p);
            }

            @Override
            public void modeCancelled() {
                ColorSelectionControls.this.m_isDropperModeCancelling = true;
                ColorSelectionControls.this.m_dropperButton.setSelected(false);
                ColorSelectionControls.this.m_isDropperModeCancelling = false;
            }
        });
    }

    private RGBColorSelection mergeColorSelections(RGBColorSelection cs) {
        if (cs.getPreset() != RGBColorSelectionPreset.AllColors) {
            float luminosityUpperFeather;
            float luminosityLowerFeather;
            float radius;
            if (this.m_prevCS != null) {
                radius = this.m_prevCS.radius;
                luminosityLowerFeather = Math.min(cs.luminosityLower, this.m_lowerLuminosityFeather);
                luminosityUpperFeather = Math.min(1.0f - cs.luminosityUpper, this.m_upperLuminosityFeather);
            } else {
                radius = cs.radius;
                luminosityLowerFeather = Math.min(cs.luminosityLower, cs.luminosityLowerFeather);
                luminosityUpperFeather = Math.min(1.0f - cs.luminosityUpper, cs.luminosityUpperFeather);
            }
            this.m_prevCS = cs = new RGBColorSelection(cs.red, cs.green, cs.blue, radius, cs.luminosityLower, luminosityLowerFeather, cs.luminosityUpper, luminosityUpperFeather, false, this.m_hueEnabled.isSelected(), this.m_luminosityEnabled.isSelected());
            this.m_lowerLuminosityFeather = cs.luminosityLowerFeather;
            this.m_upperLuminosityFeather = cs.luminosityUpperFeather;
        }
        return cs;
    }

    private void postEdit(String name) {
        this.m_currentEdit.end(name);
        this.m_undoSupport.postEdit(this.m_currentEdit);
        this.m_currentEdit = new ColorSelectionEdit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetColorSelection() {
        this.m_isUpdatingControls = true;
        this.m_op.changeBatchStarted();
        boolean undoable = false;
        try {
            if (this.m_hueEnabled.isSelected()) {
                this.m_prevCS = null;
                this.m_colorPresets.setSelectedItem(RGBColorSelectionPreset.AllColors);
                undoable = true;
            }
            if (this.m_luminosityEnabled.isSelected()) {
                this.m_luminositySelector.setProperties(this.m_luminositySelector.getMinimumThumbValue(), this.m_luminositySelector.getMaximumThumbValue(), this.m_luminositySelector.getMinimumThumbValue(), this.m_luminositySelector.getMinimumThumbValue(), this.m_luminositySelector.getMaximumThumbValue(), this.m_luminositySelector.getMaximumThumbValue(), this.m_luminositySelector.getMinimumTrackValue(), this.m_luminositySelector.getMaximumTrackValue(), this.m_luminositySelector.getTrackValue(), this.m_luminositySelector.getTrackValueWraps());
                undoable = true;
            }
            if (undoable) {
                this.postEdit(Locale.LOCALE.get("ResetColorSelectionEditName"));
            }
        }
        finally {
            this.m_op.changeBatchEnded();
            this.m_isUpdatingControls = false;
        }
    }

    private void selectColorAt(Point2D p) {
        RGBColorSelection cs = this.m_op.getColorSelectionAt(p);
        cs = this.mergeColorSelections(cs);
        this.m_op.setColorSelection(cs);
        this.colorSelectionToControls(cs, false);
        this.postEdit(Locale.LOCALE.get("ColorDropperEditName"));
    }

    private void selectPreset(RGBColorSelectionPreset p) {
        if (!this.m_skipSelectPresetCode) {
            boolean wasUpdatingControls = this.m_isUpdatingControls;
            this.m_skipSelectPresetCode = true;
            this.m_isUpdatingControls = true;
            this.m_hueEnabled.setSelected(true);
            RGBColorSelection cs = new RGBColorSelection(p, this.m_invertSelection.isSelected());
            this.m_op.setColorSelection(cs);
            this.colorSelectionToControls(cs, false);
            this.m_skipSelectPresetCode = false;
            if (!wasUpdatingControls) {
                this.postEdit(Locale.LOCALE.get("SelectColorPresetEditName", p.toString()));
            }
            this.m_prevCS = null;
            this.m_isUpdatingControls = wasUpdatingControls;
        }
    }

    private final class LocalListener
    extends MouseAdapter
    implements ChangeListener {
        private LocalListener() {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            ColorSelectionControls.this.m_op.changeBatchStarted();
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            ColorSelectionControls.this.m_op.changeBatchEnded();
            ColorSelectionControls.this.postEdit(Locale.LOCALE.get("ColorSelectorEditName"));
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            if (!ColorSelectionControls.this.m_isUpdatingControls) {
                RGBColorSelection cs = ColorSelectionControls.this.controlsToColorSelection();
                ColorSelectionControls.this.m_lowerLuminosityFeather = cs.luminosityLowerFeather;
                ColorSelectionControls.this.m_upperLuminosityFeather = cs.luminosityUpperFeather;
                ColorSelectionControls.this.m_op.setColorSelection(cs);
                ColorSelectionControls.this.m_prevCS = cs;
            }
        }
    }

    private final class EnablerListener
    implements ItemListener {
        private final String m_enabledEditName;
        private final String m_disabledEditName;
        private final String m_selectedTip;
        private final String m_unselectedTip;

        @Override
        public void itemStateChanged(ItemEvent ie) {
            if (!ColorSelectionControls.this.m_isUpdatingControls) {
                ColorSelectionControls.this.m_op.setColorSelection(ColorSelectionControls.this.controlsToColorSelection());
                JComponent comp = (JComponent)ie.getSource();
                if (ie.getStateChange() == 1) {
                    ColorSelectionControls.this.postEdit(this.m_enabledEditName);
                    comp.setToolTipText(this.m_selectedTip);
                } else {
                    ColorSelectionControls.this.postEdit(this.m_disabledEditName);
                    comp.setToolTipText(this.m_unselectedTip);
                }
            }
        }

        EnablerListener(String selectedTip, String unselectedTip) {
            this(selectedTip, unselectedTip, Locale.LOCALE.get("ColorSelectorEnabledEditName"), Locale.LOCALE.get("ColorSelectorDisabledEditName"));
        }

        EnablerListener(String selectedTip, String unselectedTip, String enabledEditName, String disabledEditName) {
            this.m_enabledEditName = enabledEditName;
            this.m_disabledEditName = disabledEditName;
            this.m_selectedTip = selectedTip;
            this.m_unselectedTip = unselectedTip;
        }
    }

    private class ColorSelectionEdit
    extends AbstractUndoableEdit {
        private RGBColorSelection m_afterHueModel;
        private final RGBColorSelection m_beforeHueModel;
        private String m_name = "";

        ColorSelectionEdit() {
            this.m_beforeHueModel = ColorSelectionControls.this.controlsToColorSelection();
        }

        void end(String name) {
            this.m_name = name;
            this.m_afterHueModel = ColorSelectionControls.this.controlsToColorSelection();
        }

        @Override
        public String getPresentationName() {
            return this.m_name;
        }

        @Override
        public void undo() {
            super.undo();
            ColorSelectionControls.this.colorSelectionToControls(this.m_beforeHueModel, true);
            ColorSelectionControls.this.m_op.setColorSelection(this.m_beforeHueModel);
            ColorSelectionControls.this.m_currentEdit = new ColorSelectionEdit();
        }

        @Override
        public void redo() {
            super.redo();
            ColorSelectionControls.this.colorSelectionToControls(this.m_afterHueModel, true);
            ColorSelectionControls.this.m_op.setColorSelection(this.m_afterHueModel);
        }
    }

    private final class ColorPresets
    extends Box {
        ButtonGroup group;

        ColorPresets() {
            super(0);
            this.group = new ButtonGroup();
            for (RGBColorSelectionPreset p : RGBColorSelectionPreset.values()) {
                if (p.equals((Object)RGBColorSelectionPreset.SampledColors)) continue;
                ColorButton button = new ColorButton(p);
                this.group.add(button);
                this.add(button);
                if (p.equals((Object)RGBColorSelectionPreset.AllColors)) {
                    button.setText("All");
                    button.setSelected(true);
                    button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 3));
                } else {
                    RGBColorSelection cs = new RGBColorSelection(p, false);
                    byte[] systemColor = new byte[3];
                    ts.doTransform(new byte[]{(byte)(255.0f * cs.red), (byte)(255.0f * cs.green), (byte)(255.0f * cs.blue)}, systemColor);
                    Color color = new Color(0xFF & systemColor[0], 0xFF & systemColor[1], 0xFF & systemColor[2]);
                    LightZoneSkin.CustomColorScheme colorScheme = new LightZoneSkin.CustomColorScheme(color);
                    SubstanceTheme theme = LightZoneSkin.makeTheme((ColorScheme)colorScheme, p.name());
                    button.putClientProperty("substancelaf.theme", theme);
                    button.putClientProperty("substancelaf.paintactive", Boolean.TRUE);
                    button.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 3));
                }
                button.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent ie) {
                        if (ie.getStateChange() == 1) {
                            ColorButton b = (ColorButton)ie.getItem();
                            ColorSelectionControls.this.selectPreset(b.m_preset);
                        }
                    }
                });
            }
            this.add(Box.createHorizontalGlue());
        }

        RGBColorSelectionPreset getSelectedItem() {
            ColorButton selection = (ColorButton)ColorSelectionControls.getSelection(this.group);
            if (selection == null) {
                return RGBColorSelectionPreset.SampledColors;
            }
            return selection.m_preset;
        }

        void setSelectedItem(RGBColorSelectionPreset p) {
            if (!p.equals((Object)RGBColorSelectionPreset.SampledColors)) {
                Enumeration<AbstractButton> e = this.group.getElements();
                while (e.hasMoreElements()) {
                    ColorButton b = (ColorButton)e.nextElement();
                    if (!b.m_preset.equals((Object)p)) continue;
                    b.setSelected(true);
                    break;
                }
            } else {
                ColorButton selection = (ColorButton)ColorSelectionControls.getSelection(this.group);
                if (selection != null) {
                    this.group.remove(selection);
                    selection.setSelected(false);
                    this.group.add(selection);
                }
            }
        }

        private final class ColorButton
        extends JRadioButton {
            final RGBColorSelectionPreset m_preset;

            ColorButton(RGBColorSelectionPreset preset) {
                this.m_preset = preset;
                this.setFocusable(false);
            }
        }
    }
}

