/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation;

import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.operation.Locale;
import com.lightcrafts.ui.operation.SelectableControl;
import com.lightcrafts.ui.toolkit.IconFactory;
import com.lightcrafts.ui.toolkit.ImageOnlyButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

class HelpButton
extends ImageOnlyButton {
    private static Icon InfoNormalIcon;
    private static Icon InfoPressedIcon;
    private static final String ToolTip;

    HelpButton(final SelectableControl control) {
        super(InfoNormalIcon, InfoPressedIcon);
        this.putClientProperty("substancelaf.buttonnominsize", Boolean.TRUE);
        this.setToolTipText(ToolTip);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String topic = control.getHelpTopic();
                Platform platform = Platform.getPlatform();
                platform.showHelpTopic(topic);
            }
        });
    }

    static {
        try {
            BufferedImage image = ImageIO.read(HelpButton.class.getResource("resources/info.png"));
            InfoNormalIcon = IconFactory.invertIcon(new ImageIcon(image));
            image = ImageIO.read(HelpButton.class.getResource("resources/infoPressed.png"));
            InfoPressedIcon = IconFactory.invertIcon(new ImageIcon(image));
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't initialize HelpButton", e);
        }
        ToolTip = Locale.LOCALE.get("HelpButtonToolTip");
    }
}

