/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation;

import com.lightcrafts.model.RedEyeOperation;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.operation.Locale;
import com.lightcrafts.ui.operation.OpControl;
import com.lightcrafts.ui.operation.clone.CloneControl;
import com.lightcrafts.ui.operation.clone.SpotControl;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JCheckBox;

class InvertRegionCheckBox
extends JCheckBox
implements ItemListener {
    private OpControl control;
    private OpControl.OpControlUndoSupport undoSupport;
    private final PropertyChangeSupport pcs;
    public static final String BLENDING_MODES = "Blending Modes";
    private static final String InvertedTag = "regionsInverted";

    InvertRegionCheckBox(OpControl control, PropertyChangeSupport pcs) {
        super("Invert Mask");
        this.control = control;
        this.undoSupport = control.undoSupport;
        this.setFont(LightZoneSkin.fontSet.getSmallFont());
        this.pcs = pcs;
        this.addItemListener(this);
        this.setFocusable(false);
        if (control instanceof CloneControl || control instanceof SpotControl || control.getOperation() instanceof RedEyeOperation) {
            this.setEnabled(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        boolean selected = event.getStateChange() == 1;
        this.control.setRegionInverted(selected);
        if (!this.undoSupport.isRestoring()) {
            this.undoSupport.postEdit(Locale.LOCALE.get("InvertMaskEditName"));
        }
        if (!this.isRegionsInverted()) {
            this.pcs.firePropertyChange(BLENDING_MODES, Boolean.TRUE, Boolean.FALSE);
        } else {
            this.pcs.firePropertyChange(BLENDING_MODES, Boolean.FALSE, Boolean.TRUE);
        }
    }

    boolean isRegionsInverted() {
        return this.isSelected();
    }

    void save(XmlNode node) {
        node.setAttribute(InvertedTag, Boolean.toString(this.isRegionsInverted()));
    }

    void restore(XmlNode node) throws XMLException {
        if (node.hasAttribute(InvertedTag)) {
            String value = node.getAttribute(InvertedTag);
            boolean isInverted = Boolean.valueOf(value);
            this.setSelected(isInverted);
        }
    }
}

