/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation;

import com.lightcrafts.model.Operation;
import com.lightcrafts.ui.operation.Locale;
import com.lightcrafts.ui.operation.OpActions;
import com.lightcrafts.ui.operation.OpControl;
import com.lightcrafts.ui.operation.OpStack;
import com.lightcrafts.ui.operation.OpTitleEditor;
import com.lightcrafts.ui.operation.SelectableTitle;
import com.lightcrafts.ui.toolkit.ImageOnlyButton;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlDocument;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;

class OpTitle
extends SelectableTitle {
    private static final Preferences Prefs = Preferences.userNodeForPackage(OpTitle.class);
    private static final String PresetsKey = "Presets";
    private OpControl control;
    private JToggleButton activeButton;
    private JButton removeButton;
    private OpTitleEditor editor;

    OpTitle(final OpControl control, final OpStack stack) {
        super(control);
        this.control = control;
        this.editor = new OpTitleEditor(this, control.undoSupport);
        this.editor.setLabel(this.label);
        Operation op = control.getOperation();
        BufferedImage image = OpActions.getIcon(op);
        this.setIcon(image);
        this.activeButton = OpTitle.createActiveButton();
        this.activeButton.setToolTipText(Locale.LOCALE.get("DisableToolTip"));
        this.activeButton.setSelected(true);
        this.activeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean active = OpTitle.this.activeButton.isSelected();
                String tip = active ? Locale.LOCALE.get("DisableToolTip") : Locale.LOCALE.get("EnableToolTip");
                OpTitle.this.activeButton.setToolTipText(tip);
                control.setActivated(OpTitle.this.activeButton.isSelected());
            }
        });
        this.removeButton = OpTitle.createGoAwayButton();
        this.removeButton.setToolTipText(Locale.LOCALE.get("RemoveToolTip"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                stack.removeControl(control);
            }
        });
        if (!control.isSingleton()) {
            this.buttonBox.add(this.activeButton);
            this.buttonBox.add(this.removeButton);
        }
    }

    OpControl getControl() {
        return this.control;
    }

    void setActive(boolean active) {
        this.activeButton.setSelected(active);
    }

    @Override
    void resetTitle(String title) {
        super.resetTitle(title);
        if (this.editor != null) {
            this.editor.setLabel(this.label);
        }
    }

    private static JButton createGoAwayButton() {
        Icon normalIcon = OpTitle.getTitleIcon("x");
        Icon highlightIcon = OpTitle.getTitleIcon("x_H");
        Icon pressedIcon = OpTitle.getTitleIcon("x_S");
        ImageOnlyButton button = new ImageOnlyButton(normalIcon, highlightIcon, pressedIcon, null);
        return button;
    }

    private static JToggleButton createActiveButton() {
        JToggleButton button = new JToggleButton();
        Icon normalIcon = OpTitle.getTitleIcon("nocheck");
        Icon selectedIcon = OpTitle.getTitleIcon("check");
        Icon normalHighlightIcon = OpTitle.getTitleIcon("nocheck_H");
        Icon selectedHighlightIcon = OpTitle.getTitleIcon("check_H");
        button.setIcon(normalIcon);
        button.setSelectedIcon(selectedIcon);
        button.setRolloverIcon(normalHighlightIcon);
        button.setRolloverSelectedIcon(selectedHighlightIcon);
        button.setRolloverEnabled(true);
        ImageOnlyButton.setStyle(button);
        return button;
    }

    @Override
    JPopupMenu getPopupMenu() {
        JPopupMenu menu = super.getPopupMenu();
        final OpStack stack = this.findOpStack();
        boolean isLocked = this.control.isLocked();
        if (!this.control.isSingleton()) {
            if (!this.control.isActivated()) {
                JMenuItem enableItem = new JMenuItem(Locale.LOCALE.get("EnableMenuItem"));
                enableItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        OpTitle.this.control.setActivated(true);
                    }
                });
                enableItem.setEnabled(!isLocked);
                menu.add((Component)enableItem, 0);
            } else {
                JMenuItem disableItem = new JMenuItem(Locale.LOCALE.get("DisableMenuItem"));
                disableItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        OpTitle.this.control.setActivated(false);
                    }
                });
                disableItem.setEnabled(!isLocked);
                menu.add((Component)disableItem, 0);
            }
            menu.add((Component)new JSeparator(), 1);
        }
        if (!isLocked) {
            JMenuItem lockItem = new JMenuItem(Locale.LOCALE.get("LockMenuItem"));
            lockItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    OpTitle.this.control.setLocked(true);
                }
            });
            menu.add((Component)lockItem, 2);
        } else {
            JMenuItem unlockItem = new JMenuItem(Locale.LOCALE.get("UnlockMenuItem"));
            unlockItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    OpTitle.this.control.setLocked(false);
                }
            });
            menu.add((Component)unlockItem, 2);
        }
        menu.add((Component)new JSeparator(), 3);
        JMenuItem savePreset = new JMenuItem(Locale.LOCALE.get("RememberPresetMenuItem"));
        savePreset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                XmlDocument preset = new XmlDocument("Preset");
                OpTitle.this.control.save(preset.getRoot());
                OpTitle.this.writePreset(preset);
            }
        });
        menu.add((Component)savePreset, 4);
        JMenuItem applyPreset = new JMenuItem(Locale.LOCALE.get("ApplyPresetMenuItem"));
        final XmlDocument preset = this.readPreset();
        applyPreset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    OpTitle.this.control.restorePresets(preset.getRoot());
                }
                catch (XMLException e) {
                    System.err.println("Error in preset restore: " + e.getMessage());
                }
            }
        });
        if (preset == null || isLocked) {
            applyPreset.setEnabled(false);
        }
        menu.add((Component)applyPreset, 5);
        if (!this.control.isSingleton()) {
            JMenuItem deleteItem = new JMenuItem(Locale.LOCALE.get("DeleteMenuItem"));
            deleteItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    stack.removeControl(OpTitle.this.control);
                }
            });
            deleteItem.setEnabled(!isLocked);
            menu.add(new JSeparator());
            menu.add(deleteItem);
        }
        return menu;
    }

    private XmlDocument readPreset() {
        String key = this.getPresetsKey();
        String text = Prefs.get(key, "");
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(text.getBytes("UTF-8"));
            return new XmlDocument(in);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void writePreset(XmlDocument preset) {
        String key = this.getPresetsKey();
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            preset.write(out);
            String text = out.toString("UTF-8");
            Prefs.put(key, text);
            Prefs.sync();
        }
        catch (Exception e) {
            Prefs.remove(key);
        }
    }

    private String getPresetsKey() {
        String name = this.control.getOperation().getType().getName();
        return PresetsKey + name;
    }
}

