/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation.zone;

import com.lightcrafts.ui.operation.zone.Spacer;
import com.lightcrafts.ui.operation.zone.ZoneModel;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;

class DragListener
extends MouseInputAdapter {
    private ZoneModel model;
    private Point startCursor;
    private Point startComponent;
    private boolean dragging;

    DragListener() {
    }

    void setModel(ZoneModel model) {
        this.model = model;
    }

    void addSelfTo(Spacer spacer) {
        spacer.addMouseListener(this);
        spacer.addMouseMotionListener(this);
    }

    void removeSelfFrom(Spacer spacer) {
        spacer.removeMouseListener(this);
        spacer.removeMouseMotionListener(this);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        Spacer spacer = (Spacer)event.getComponent();
        event.translatePoint(spacer.getX(), spacer.getY());
        this.startCursor = event.getPoint();
        this.startComponent = spacer.getLocation();
        this.dragging = true;
        this.notifyDragStart();
        spacer.updateModel();
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.dragging) {
            Component c = event.getComponent();
            event.translatePoint(c.getX(), c.getY());
            Point p1 = this.startCursor;
            Point p2 = event.getPoint();
            Point interval = new Point(p2.x - p1.x, p2.y - p1.y);
            Spacer spacer = (Spacer)c;
            spacer.moveTo(this.startComponent.y + interval.y);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.dragging) {
            this.notifyDragEnd();
            this.dragging = false;
        }
    }

    void notifyDragStart() {
        this.model.batchStart();
    }

    void notifyDragEnd() {
        this.model.batchEnd();
    }
}

