/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation.zone;

import com.lightcrafts.model.ZoneOperation;
import com.lightcrafts.ui.operation.zone.ZoneModelEvent;
import com.lightcrafts.ui.operation.zone.ZoneModelListener;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.util.LinkedList;

class ZoneModel {
    private ZoneOperation op;
    private int size;
    private double[] points;
    private LinkedList listeners;
    private int batch;
    private static final String SizeTag = "Size";
    private static final String PointsTag = "Points";
    private static final String PointTag = "Point";
    private static final String XTag = "X";
    private static final String YTag = "Y";

    ZoneModel(ZoneOperation op, int size) {
        this.op = op;
        this.size = size;
        this.listeners = new LinkedList();
        this.reset();
    }

    void operationChanged(ZoneOperation op) {
        this.op = op;
        this.push();
    }

    void addZoneModelListener(ZoneModelListener listener) {
        this.listeners.add(listener);
    }

    void removeZoneModelListener(ZoneModelListener listener) {
        this.listeners.remove(listener);
    }

    int getSize() {
        return this.size;
    }

    void reset() {
        this.points = new double[this.size + 1];
        for (int n = 0; n <= this.size; ++n) {
            this.points[n] = -1.0;
        }
        this.push();
    }

    void setPoint(int index, double value) {
        this.checkValue(index, value);
        this.points[index] = value;
        this.push();
    }

    void removePoint(int index) {
        this.points[index] = -1.0;
        this.push();
    }

    boolean containsPoint(int index) {
        return this.points[index] >= 0.0;
    }

    double getValueAt(int index) {
        return this.op.getControlPoint(index);
    }

    void checkValue(int index, double value) {
        if (index < 0 || index > this.size) {
            throw new IllegalArgumentException("Illegal index: " + index);
        }
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException("Illegal value: " + value);
        }
        double max = 0.0;
        for (int n = 0; n <= this.size; ++n) {
            if (n == index) {
                if (value < max) {
                    throw new IllegalArgumentException("Non-monotonic pair: (" + index + ", " + value + ")");
                }
                max = value;
                continue;
            }
            if (!(this.points[n] >= 0.0)) continue;
            if (this.points[n] < max) {
                throw new IllegalArgumentException("Non-monotonic pair: (" + index + ", " + value + ")");
            }
            max = this.points[n];
        }
    }

    void batchStart() {
        if (this.batch++ == 0) {
            this.notifyListenersStart();
        }
    }

    void batchEnd() {
        if (--this.batch == 0) {
            this.notifyListenersEnd();
        }
    }

    private void push() {
        double[] copy = new double[this.points.length];
        System.arraycopy(this.points, 0, copy, 0, this.points.length);
        this.op.setControlPoints(copy);
        this.notifyListenersChanged();
    }

    private void notifyListenersChanged() {
        ZoneModelEvent event = new ZoneModelEvent(this);
        for (ZoneModelListener listener : this.listeners) {
            listener.zoneModelChanged(event);
        }
    }

    private void notifyListenersStart() {
        this.op.changeBatchStarted();
        ZoneModelEvent event = new ZoneModelEvent(this);
        for (ZoneModelListener listener : this.listeners) {
            listener.zoneModelBatchStart(event);
        }
    }

    private void notifyListenersEnd() {
        this.op.changeBatchEnded();
        ZoneModelEvent event = new ZoneModelEvent(this);
        for (ZoneModelListener listener : this.listeners) {
            listener.zoneModelBatchEnd(event);
        }
    }

    void save(XmlNode node) {
        XmlNode ptsNode = node.addChild(PointsTag);
        ptsNode.setAttribute(SizeTag, Integer.toString(this.size));
        for (int n = 0; n < this.points.length; ++n) {
            if (!(this.points[n] >= 0.0)) continue;
            Integer key = n;
            Double value = this.points[n];
            XmlNode ptNode = ptsNode.addChild(PointTag);
            ptNode.setAttribute(XTag, key.toString());
            ptNode.setAttribute(YTag, value.toString());
        }
    }

    void restore(XmlNode node) throws XMLException {
        XmlNode[] ptNodes;
        XmlNode ptsNode = node.getChild(PointsTag);
        try {
            int s = Integer.parseInt(ptsNode.getAttribute(SizeTag));
            if (s != this.size) {
                throw new XMLException("Unsupported size change");
            }
            this.reset();
        }
        catch (NumberFormatException e) {
            throw new XMLException("Not an integer: \"" + ptsNode.getAttribute(SizeTag) + "\"", e);
        }
        for (XmlNode ptNode : ptNodes = ptsNode.getChildren(PointTag)) {
            Double value;
            Integer key;
            try {
                key = Integer.valueOf(ptNode.getAttribute(XTag));
            }
            catch (NumberFormatException e) {
                throw new XMLException("Not an integer: \"" + ptNode.getAttribute(XTag) + "\"", e);
            }
            try {
                value = Double.valueOf(ptNode.getAttribute(YTag));
            }
            catch (NumberFormatException e) {
                throw new XMLException("Not a number: \"" + ptNode.getAttribute(YTag) + "\"", e);
            }
            try {
                this.setPoint(key, value);
            }
            catch (IllegalArgumentException e) {
                throw new XMLException("Invalid zone mapping: (" + key + ", " + value + ")");
            }
        }
        this.notifyListenersChanged();
    }
}

