/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.print;

import com.lightcrafts.model.RenderingIntent;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.print.Locale;
import com.lightcrafts.ui.print.PrintLayoutModel;
import com.lightcrafts.ui.toolkit.WidePopupComboBox;
import com.lightcrafts.utils.ColorProfileInfo;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

class ColorManagementPanel
extends JPanel {
    private static Collection<ColorProfileInfo> PrinterProfiles = Platform.getPlatform().getPrinterProfiles();
    private static final String APPLICATION_COLORS = Locale.LOCALE.get("AppColors");
    private static final String PRINTER_COLORS = Locale.LOCALE.get("PrinterColors");
    private static final int PreferredComboWidth = 400;
    private PrintLayoutModel model;
    private JComboBox colorHandling;
    private JComboBox printerProfile;
    private JComboBox renderingIntent;
    private JPanel titlePanel;

    ColorManagementPanel(PrintLayoutModel model) {
        this.model = model;
        this.titlePanel = new JPanel();
        this.titlePanel.setLayout(new BoxLayout(this.titlePanel, 1));
        TitledBorder border = BorderFactory.createTitledBorder(Locale.LOCALE.get("ColorTitle"));
        this.titlePanel.setBorder(border);
        this.addColorHandling();
        this.titlePanel.add(Box.createVerticalStrut(3));
        this.addPrinterProfile();
        this.titlePanel.add(Box.createVerticalStrut(3));
        this.addRenderingIntent();
        ColorProfileInfo profile = model.getColorProfileInfo();
        String selected = profile != null ? APPLICATION_COLORS : PRINTER_COLORS;
        this.colorHandling.setSelectedItem(selected);
        this.setLayout(new BorderLayout());
        this.add(this.titlePanel);
    }

    private void addColorHandling() {
        this.colorHandling = new JComboBox();
        this.colorHandling.addItem(APPLICATION_COLORS);
        this.colorHandling.addItem(PRINTER_COLORS);
        ColorManagementPanel.setFixedSize(this.colorHandling);
        Box box = ColorManagementPanel.createLabelCombo(Locale.LOCALE.get("HandlingLabel"), this.colorHandling);
        this.titlePanel.add(box);
        this.colorHandling.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (e.getItem() == APPLICATION_COLORS) {
                        ColorManagementPanel.this.renderingIntent.setEnabled(true);
                        ColorManagementPanel.this.printerProfile.setEnabled(true);
                        ColorProfileInfo cpi = null;
                        Object stuff = ColorManagementPanel.this.printerProfile.getSelectedItem();
                        if (stuff instanceof ColorProfileInfo) {
                            cpi = (ColorProfileInfo)stuff;
                        }
                        ColorManagementPanel.this.model.setColorProfile(cpi);
                    } else {
                        ColorManagementPanel.this.renderingIntent.setEnabled(false);
                        ColorManagementPanel.this.printerProfile.setEnabled(false);
                        ColorManagementPanel.this.model.setColorProfile(null);
                    }
                }
            }
        });
    }

    private void addPrinterProfile() {
        this.printerProfile = new WidePopupComboBox();
        ColorManagementPanel.setFixedSize(this.printerProfile);
        List<ColorProfileInfo> profiles = ColorProfileInfo.arrangeForMenu(PrinterProfiles);
        for (ColorProfileInfo profile : profiles) {
            this.printerProfile.addItem(profile);
        }
        ColorProfileInfo initProfile = this.model.getColorProfileInfo();
        if (initProfile != null) {
            for (ColorProfileInfo profile : profiles) {
                if (profile == null || !profile.getName().equals(initProfile.getName())) continue;
                this.printerProfile.setSelectedItem(profile);
            }
        }
        this.printerProfile.setMaximumRowCount(25);
        Box box = ColorManagementPanel.createLabelCombo(Locale.LOCALE.get("ProfileLabel"), this.printerProfile);
        this.titlePanel.add(box);
        this.printerProfile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ColorProfileInfo cpi = (ColorProfileInfo)ColorManagementPanel.this.printerProfile.getSelectedItem();
                    ColorManagementPanel.this.model.setColorProfile(cpi);
                }
            }
        });
    }

    private void addRenderingIntent() {
        RenderingIntent[] intents;
        this.renderingIntent = new JComboBox();
        ColorManagementPanel.setFixedSize(this.renderingIntent);
        for (RenderingIntent intent : intents = RenderingIntent.getAll()) {
            this.renderingIntent.addItem(intent);
        }
        RenderingIntent intent = this.model.getRenderingIntent();
        this.renderingIntent.setSelectedItem(intent);
        Box box = ColorManagementPanel.createLabelCombo(Locale.LOCALE.get("IntentLabel"), this.renderingIntent);
        this.titlePanel.add(box);
        this.renderingIntent.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    RenderingIntent intent = (RenderingIntent)ColorManagementPanel.this.renderingIntent.getSelectedItem();
                    ColorManagementPanel.this.model.setRenderingIntent(intent);
                }
            }
        });
    }

    private static void setFixedSize(JComboBox combo) {
        Dimension size = combo.getPreferredSize();
        size = new Dimension(400, size.height);
        combo.setMinimumSize(size);
        combo.setPreferredSize(size);
        combo.setMaximumSize(size);
    }

    private static Box createLabelCombo(String name, JComboBox combo) {
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(new JLabel(name + ':'));
        box.add(Box.createHorizontalStrut(3));
        box.add(combo);
        return box;
    }

    public static void main(String[] args) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(new ColorManagementPanel(new PrintLayoutModel(100, 100)));
        JFrame frame = new JFrame("ColorManagementPanel Test");
        frame.setContentPane(panel);
        frame.setLocation(100, 100);
        frame.pack();
        frame.setVisible(true);
    }
}

