/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.print;

import com.lightcrafts.model.PrintSettings;
import com.lightcrafts.model.RenderingIntent;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.platform.PrinterLayer;
import com.lightcrafts.ui.print.PreviewComponent;
import com.lightcrafts.ui.print.PrintLayoutModelListener;
import com.lightcrafts.utils.ColorProfileInfo;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.util.LinkedList;

public class PrintLayoutModel {
    private int imageWidth;
    private int imageHeight;
    private int pixelsPerInch;
    private double aspectRatio;
    private ColorProfileInfo profile;
    private RenderingIntent intent;
    private PageFormat pageFormat;
    private Rectangle2D imageRect;
    private boolean keepCentered;
    private LinkedList<PrintLayoutModelListener> listeners;
    private static final String ProfileTag = "Profile";
    private static final String IntentTag = "Intent";
    private static final String PageTag = "Page";
    private static final String ImageRectTag = "ImageBounds";
    private static final String CenteredTag = "Centered";
    private static final String PpiTag = "ppi";
    private static final String ProfileNameTag = "Name";
    private static final String ProfilePathTag = "Path";
    private static final String OrientationTag = "Orientation";
    private static final String PaperTag = "Paper";

    public PrintLayoutModel(int width, int height) {
        PrinterLayer printer = Platform.getPlatform().getPrinterLayer();
        printer.initialize();
        this.pageFormat = printer.getPageFormat();
        printer.dispose();
        this.listeners = new LinkedList();
        this.pixelsPerInch = 300;
        this.updateImageSize(width, height);
        this.intent = RenderingIntent.PERCEPTUAL;
    }

    public void updateImageSize(int width, int height) {
        if (width == this.imageWidth && height == this.imageHeight) {
            return;
        }
        this.imageWidth = width;
        this.imageHeight = height;
        this.aspectRatio = (double)width / (double)height;
        this.scaleToFit();
    }

    public RenderingIntent getRenderingIntent() {
        return this.intent;
    }

    public void setRenderingIntent(RenderingIntent intent) {
        this.intent = intent;
        this.notifyListeners();
    }

    public ColorProfileInfo getColorProfileInfo() {
        return this.profile;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
        if (this.keepCentered) {
            this.centerByTranslation();
        }
        this.notifyListeners();
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public void setColorProfile(ColorProfileInfo profile) {
        this.profile = profile;
        this.notifyListeners();
    }

    public Rectangle2D getImageRect() {
        return (Rectangle2D)this.imageRect.clone();
    }

    public PrintSettings getPrintSettings() {
        PrintSettings settings = new PrintSettings();
        settings.setRenderingIntent(this.intent);
        settings.setColorProfile(this.profile != null ? this.profile.getICCProfile() : null);
        settings.setPrintBounds(this.imageRect);
        settings.setPixelsPerInch(this.pixelsPerInch);
        return settings;
    }

    void setImageX(double leftInset, LengthUnit unit) {
        leftInset = unit.toPoints(leftInset);
        this.setImageXSilent(leftInset);
        this.keepCentered = false;
        this.notifyListeners();
    }

    void setImageY(double topInset, LengthUnit unit) {
        topInset = unit.toPoints(topInset);
        this.setImageYSilent(topInset);
        this.keepCentered = false;
        this.notifyListeners();
    }

    void setImageWidth(double width, LengthUnit unit) {
        width = unit.toPoints(width);
        this.setImageWidthSilent(width);
        this.setImageHeightSilent(width / this.aspectRatio);
        if (this.keepCentered) {
            this.centerByTranslation();
        }
        this.notifyListeners();
    }

    void setImageHeight(double height, LengthUnit unit) {
        height = unit.toPoints(height);
        this.setImageWidthSilent(height * this.aspectRatio);
        this.setImageHeightSilent(height);
        if (this.keepCentered) {
            this.centerByTranslation();
        }
        this.notifyListeners();
    }

    void setKeepCentered(boolean keepCentered) {
        this.keepCentered = keepCentered;
        if (keepCentered) {
            this.centerByTranslation();
        }
        this.notifyListeners();
    }

    void setPpi(int ppi) {
        this.pixelsPerInch = ppi;
    }

    int getPpi() {
        return this.pixelsPerInch;
    }

    double getScale() {
        double widthInInches = LengthUnit.INCH.fromPoints(this.imageRect.getWidth());
        return (double)this.pixelsPerInch * widthInInches / (double)this.imageWidth;
    }

    void setScale(double scale) {
        double widthInInches = scale * (double)this.imageWidth / (double)this.pixelsPerInch;
        this.setImageWidth(widthInInches, LengthUnit.INCH);
    }

    boolean isKeepCentered() {
        return this.keepCentered;
    }

    void scaleToFit() {
        Rectangle2D.Double imageableRect = new Rectangle2D.Double(this.pageFormat.getImageableX(), this.pageFormat.getImageableY(), this.pageFormat.getImageableWidth(), this.pageFormat.getImageableHeight());
        Point2D center = this.getPaperCenter();
        double minHalfWidth = Math.min(center.getX() - ((RectangularShape)imageableRect).getX(), ((RectangularShape)imageableRect).getX() + ((RectangularShape)imageableRect).getWidth() - center.getX());
        double minHalfHeight = Math.min(center.getY() - ((RectangularShape)imageableRect).getY(), ((RectangularShape)imageableRect).getY() + ((RectangularShape)imageableRect).getHeight() - center.getY());
        Rectangle2D.Double fitRect = new Rectangle2D.Double(center.getX() - minHalfWidth, center.getY() - minHalfHeight, 2.0 * minHalfWidth, 2.0 * minHalfHeight);
        this.imageRect = PreviewComponent.getImageBounds(fitRect, this.aspectRatio);
        this.notifyListeners();
    }

    void addListener(PrintLayoutModelListener listener) {
        this.listeners.add(listener);
    }

    void removeListener(PrintLayoutModelListener listener) {
        this.listeners.remove(listener);
    }

    private void setImageXSilent(double x) {
        this.imageRect.setRect(x, this.imageRect.getY(), this.imageRect.getWidth(), this.imageRect.getHeight());
    }

    private void setImageYSilent(double y) {
        this.imageRect.setRect(this.imageRect.getX(), y, this.imageRect.getWidth(), this.imageRect.getHeight());
    }

    private void setImageWidthSilent(double width) {
        this.imageRect.setRect(this.imageRect.getX(), this.imageRect.getY(), width, this.imageRect.getHeight());
    }

    private void setImageHeightSilent(double height) {
        this.imageRect.setRect(this.imageRect.getX(), this.imageRect.getY(), this.imageRect.getWidth(), height);
    }

    private Point2D getPaperCenter() {
        Paper paper = this.pageFormat.getPaper();
        double width = paper.getWidth();
        double height = paper.getHeight();
        if (this.pageFormat.getOrientation() != 1) {
            double temp = width;
            width = height;
            height = temp;
        }
        double centerX = width / 2.0;
        double centerY = height / 2.0;
        return new Point2D.Double(centerX, centerY);
    }

    private void centerByTranslation() {
        Point2D center = this.getPaperCenter();
        double x = center.getX() - this.imageRect.getWidth() / 2.0;
        double y = center.getY() - this.imageRect.getHeight() / 2.0;
        this.setImageXSilent(x);
        this.setImageYSilent(y);
    }

    private void notifyListeners() {
        for (PrintLayoutModelListener listener : this.listeners) {
            listener.layoutChanged(this);
        }
    }

    public void save(XmlNode root) {
        root.setAttribute(CenteredTag, this.keepCentered ? "True" : "False");
        root.setAttribute(IntentTag, this.intent.toString());
        root.setAttribute(PpiTag, Integer.toString(this.pixelsPerInch));
        if (this.profile != null) {
            XmlNode profileNode = root.addChild(ProfileTag);
            profileNode.setAttribute(ProfileNameTag, this.profile.getName());
            profileNode.setAttribute(ProfilePathTag, this.profile.getPath());
        }
        XmlNode pageNode = root.addChild(PageTag);
        this.savePageFormat(pageNode);
        XmlNode imageRectNode = root.addChild(ImageRectTag);
        imageRectNode.setAttribute("x", Double.toString(this.imageRect.getX()));
        imageRectNode.setAttribute("y", Double.toString(this.imageRect.getY()));
        imageRectNode.setAttribute("w", Double.toString(this.imageRect.getWidth()));
        imageRectNode.setAttribute("h", Double.toString(this.imageRect.getHeight()));
    }

    public void restore(XmlNode root) throws XMLException {
        this.keepCentered = Boolean.valueOf(root.getAttribute(CenteredTag));
        String intentName = root.getAttribute(IntentTag);
        RenderingIntent[] intents = RenderingIntent.getAll();
        this.intent = null;
        for (RenderingIntent i : intents) {
            if (!intentName.equals(i.toString())) continue;
            this.intent = i;
        }
        if (this.intent == null) {
            throw new XMLException("Invalid rendering intent: " + intentName);
        }
        this.pixelsPerInch = root.hasAttribute(PpiTag) ? Integer.parseInt(root.getAttribute(PpiTag)) : 300;
        this.profile = null;
        XmlNode profileNode = null;
        try {
            profileNode = root.getChild(ProfileTag);
        }
        catch (XMLException e) {
            // empty catch block
        }
        if (profileNode != null) {
            String profileName = profileNode.getAttribute(ProfileNameTag);
            String profilePath = profileNode.getAttribute(ProfilePathTag);
            this.profile = new ColorProfileInfo(profileName, profilePath);
        }
        XmlNode pageNode = root.getChild(PageTag);
        this.restorePageFormat(pageNode);
        XmlNode imageRectNode = root.getChild(ImageRectTag);
        try {
            double currentAspect;
            double x = Double.valueOf(imageRectNode.getAttribute("x"));
            double y = Double.valueOf(imageRectNode.getAttribute("y"));
            double w = Double.valueOf(imageRectNode.getAttribute("w"));
            double h = Double.valueOf(imageRectNode.getAttribute("h"));
            this.imageRect = new Rectangle2D.Double(x, y, w, h);
            double restoredAspect = this.imageRect.getWidth() / this.imageRect.getHeight();
            double d = currentAspect = this.imageWidth > 0 && this.imageHeight > 0 ? (double)this.imageWidth / (double)this.imageHeight : restoredAspect;
            if (Math.abs(restoredAspect / currentAspect - 1.0) > 0.01) {
                this.scaleToFit();
            }
        }
        catch (NumberFormatException e) {
            throw new XMLException("Can't interpret image bounds: " + e.getMessage());
        }
    }

    private void savePageFormat(XmlNode pageRoot) {
        int orientation = this.pageFormat.getOrientation();
        pageRoot.setAttribute(OrientationTag, Integer.toString(orientation));
        Paper paper = this.pageFormat.getPaper();
        XmlNode paperNode = pageRoot.addChild(PaperTag);
        paperNode.setAttribute("width", Double.toString(paper.getWidth()));
        paperNode.setAttribute("height", Double.toString(paper.getHeight()));
        paperNode.setAttribute("x", Double.toString(paper.getImageableX()));
        paperNode.setAttribute("y", Double.toString(paper.getImageableY()));
        paperNode.setAttribute("w", Double.toString(paper.getImageableWidth()));
        paperNode.setAttribute("h", Double.toString(paper.getImageableHeight()));
    }

    private void restorePageFormat(XmlNode pageRoot) throws XMLException {
        int orientation = Integer.parseInt(pageRoot.getAttribute(OrientationTag));
        this.pageFormat.setOrientation(orientation);
        Paper paper = this.pageFormat.getPaper();
        XmlNode paperNode = pageRoot.getChild(PaperTag);
        if (paperNode.hasAttribute("width") && paperNode.hasAttribute("height")) {
            double width = Double.parseDouble(paperNode.getAttribute("width"));
            double height = Double.parseDouble(paperNode.getAttribute("height"));
            paper.setSize(width, height);
        }
        double x = Double.parseDouble(paperNode.getAttribute("x"));
        double y = Double.parseDouble(paperNode.getAttribute("y"));
        double w = Double.parseDouble(paperNode.getAttribute("w"));
        double h = Double.parseDouble(paperNode.getAttribute("h"));
        paper.setImageableArea(x, y, w, h);
        this.pageFormat.setPaper(paper);
    }

    static class LengthUnit {
        static final LengthUnit POINT = new LengthUnit("points", 1.0);
        static final LengthUnit INCH = new LengthUnit("inches", 0.013888888888888888);
        static final LengthUnit CM = new LengthUnit("cm", 0.035277777777777776);
        private String name;
        private double unitsPerPoint;

        private LengthUnit(String name, double unitsPerPoint) {
            this.name = name;
            this.unitsPerPoint = unitsPerPoint;
        }

        public String toString() {
            return this.name;
        }

        double toPoints(double length) {
            return length / this.unitsPerPoint;
        }

        double fromPoints(double length) {
            return length * this.unitsPerPoint;
        }

        static LengthUnit[] getAll() {
            return new LengthUnit[]{INCH, CM, POINT};
        }
    }
}

