/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.print;

import com.lightcrafts.ui.print.DimensionTextField;
import com.lightcrafts.ui.print.Locale;
import com.lightcrafts.ui.print.PpiComboBox;
import com.lightcrafts.ui.print.PrintLayoutModel;
import com.lightcrafts.ui.print.PrintLayoutModelListener;
import com.lightcrafts.ui.print.ScaleTextField;
import com.lightcrafts.ui.print.UnitComboBox;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

class SizePanel
extends JPanel
implements PrintLayoutModelListener {
    private PrintLayoutModel model;
    private PpiComboBox scaleCombo;
    private ScaleTextField scaleText;
    private JButton scaleButton;
    private DimensionTextField heightText;
    private UnitComboBox heightUnit;
    private DimensionTextField widthText;
    private UnitComboBox widthUnit;
    private boolean readingFromModel;
    private JComponent writingToModel;
    private JPanel titlePanel;

    SizePanel(PrintLayoutModel model) {
        this.model = model;
        this.titlePanel = new JPanel();
        this.titlePanel.setLayout(new BoxLayout(this.titlePanel, 1));
        TitledBorder border = BorderFactory.createTitledBorder(Locale.LOCALE.get("SizeTitle"));
        this.titlePanel.setBorder(border);
        this.addPpi();
        this.add(Box.createVerticalStrut(3));
        this.addScale();
        this.titlePanel.add(Box.createVerticalStrut(3));
        this.addWidth();
        this.titlePanel.add(Box.createVerticalStrut(3));
        this.addHeight();
        model.addListener(this);
        this.setLayout(new BorderLayout());
        this.add(this.titlePanel);
    }

    private void addPpi() {
        this.scaleCombo = new PpiComboBox();
        this.updatePpi();
        this.scaleCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    int ppi = SizePanel.this.scaleCombo.getPpi();
                    SizePanel.this.model.setPpi(ppi);
                    SizePanel.this.updateScale();
                }
            }
        });
        Box box = SizePanel.createLabelledText(Locale.LOCALE.get("PpiLabel"), this.scaleCombo);
        this.titlePanel.add(box);
    }

    private void addScale() {
        this.scaleText = new ScaleTextField();
        this.updateScale();
        this.scaleText.setListener(new ScaleTextField.Listener(){

            @Override
            public void scaleChanged(double scale) {
                if (!SizePanel.this.readingFromModel) {
                    SizePanel.this.writingToModel = SizePanel.this.scaleText;
                    SizePanel.this.model.setScale(scale);
                    SizePanel.this.writingToModel = null;
                }
            }
        });
        this.scaleButton = new JButton(Locale.LOCALE.get("ScaleButton"));
        this.scaleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SizePanel.this.model.scaleToFit();
            }
        });
        Box box = SizePanel.createLabelledText(Locale.LOCALE.get("ScaleLabel"), this.scaleText, this.scaleButton);
        this.titlePanel.add(box);
    }

    private void addHeight() {
        this.heightText = new DimensionTextField();
        this.heightUnit = new UnitComboBox();
        this.updateHeight();
        this.heightText.setListener(new DimensionTextField.Listener(){

            @Override
            public void dimensionChanged(double height) {
                if (!SizePanel.this.readingFromModel) {
                    SizePanel.this.writingToModel = SizePanel.this.heightText;
                    PrintLayoutModel.LengthUnit unit = SizePanel.this.heightUnit.getSelectedUnit();
                    SizePanel.this.model.setImageHeight(height, unit);
                    SizePanel.this.writingToModel = null;
                }
            }
        });
        SizePanel.syncTextWithUnit(this.heightText, this.heightUnit);
        Box box = SizePanel.createLabelledText(Locale.LOCALE.get("HeightLabel"), this.heightText, this.heightUnit);
        this.titlePanel.add(box);
    }

    private void addWidth() {
        this.widthText = new DimensionTextField();
        this.widthUnit = new UnitComboBox();
        this.updateWidth();
        this.widthText.setListener(new DimensionTextField.Listener(){

            @Override
            public void dimensionChanged(double width) {
                if (!SizePanel.this.readingFromModel) {
                    SizePanel.this.writingToModel = SizePanel.this.widthText;
                    PrintLayoutModel.LengthUnit unit = SizePanel.this.widthUnit.getSelectedUnit();
                    SizePanel.this.model.setImageWidth(width, unit);
                    SizePanel.this.writingToModel = null;
                }
            }
        });
        SizePanel.syncTextWithUnit(this.widthText, this.widthUnit);
        Box box = SizePanel.createLabelledText(Locale.LOCALE.get("WidthLabel"), this.widthText, this.widthUnit);
        this.titlePanel.add(box);
    }

    private static void syncTextWithUnit(final DimensionTextField text, final UnitComboBox unit) {
        unit.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    double oldDim = text.getDimension();
                    PrintLayoutModel.LengthUnit oldUnit = text.getUnit();
                    PrintLayoutModel.LengthUnit newUnit = unit.getSelectedUnit();
                    double newDim = newUnit.fromPoints(oldUnit.toPoints(oldDim));
                    text.setUnit(newUnit);
                    text.setDimension(newDim);
                }
            }
        });
    }

    private static Box createLabelledText(String name, JComponent text, JComponent units) {
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(new JLabel(name));
        box.add(Box.createHorizontalStrut(3));
        box.add(text);
        box.add(Box.createHorizontalStrut(3));
        box.add(units);
        return box;
    }

    private static Box createLabelledText(String name, JComponent text) {
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(new JLabel(name + ':'));
        box.add(Box.createHorizontalStrut(3));
        box.add(text);
        return box;
    }

    private void updatePpi() {
        int ppi = this.model.getPpi();
        this.scaleCombo.setPpi(ppi);
    }

    private void updateScale() {
        double scale = this.model.getScale();
        this.scaleText.setScale(scale);
    }

    private void updateHeight() {
        double h = this.model.getImageRect().getHeight();
        PrintLayoutModel.LengthUnit unit = (PrintLayoutModel.LengthUnit)this.heightUnit.getSelectedItem();
        h = unit.fromPoints(h);
        this.heightText.setUnit(unit);
        this.heightText.setDimension(h);
    }

    private void updateWidth() {
        double w = this.model.getImageRect().getWidth();
        PrintLayoutModel.LengthUnit unit = (PrintLayoutModel.LengthUnit)this.widthUnit.getSelectedItem();
        w = unit.fromPoints(w);
        this.widthText.setUnit(unit);
        this.widthText.setDimension(w);
    }

    @Override
    public void layoutChanged(PrintLayoutModel source) {
        this.readingFromModel = true;
        if (this.writingToModel != this.widthText) {
            this.updateWidth();
        }
        if (this.writingToModel != this.heightText) {
            this.updateHeight();
        }
        if (this.writingToModel != this.scaleText) {
            this.updateScale();
        }
        this.readingFromModel = false;
    }

    public static void main(String[] args) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(new SizePanel(new PrintLayoutModel(100, 100)));
        JFrame frame = new JFrame("SizePanel Test");
        frame.setContentPane(panel);
        frame.setLocation(100, 100);
        frame.pack();
        frame.setVisible(true);
    }
}

