/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region;

import com.lightcrafts.ui.region.CurveComponent;
import com.lightcrafts.ui.region.CurveIterator;
import com.lightcrafts.ui.region.CurveSelection;
import com.lightcrafts.ui.region.RegionModel;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;

class CurveNudger {
    private static final KeyStroke LeftKey1 = KeyStroke.getKeyStroke(37, 0);
    private static final KeyStroke LeftKey2 = KeyStroke.getKeyStroke(226, 0);
    private static final KeyStroke RightKey1 = KeyStroke.getKeyStroke(39, 0);
    private static final KeyStroke RightKey2 = KeyStroke.getKeyStroke(227, 0);
    private static final KeyStroke UpKey1 = KeyStroke.getKeyStroke(38, 0);
    private static final KeyStroke UpKey2 = KeyStroke.getKeyStroke(224, 0);
    private static final KeyStroke DownKey1 = KeyStroke.getKeyStroke(40, 0);
    private static final KeyStroke DownKey2 = KeyStroke.getKeyStroke(225, 0);
    private CurveComponent comp;
    private RegionModel model;
    private Action leftAction;
    private Action rightAction;
    private Action upAction;
    private Action downAction;
    private boolean registered;

    CurveNudger(RegionModel model, CurveComponent comp) {
        this.comp = comp;
        this.model = model;
        this.leftAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CurveNudger.this.moveSelectedCurves(-1, 0);
            }
        };
        this.rightAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CurveNudger.this.moveSelectedCurves(1, 0);
            }
        };
        this.upAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CurveNudger.this.moveSelectedCurves(0, -1);
            }
        };
        this.downAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CurveNudger.this.moveSelectedCurves(0, 1);
            }
        };
    }

    void registerKeys() {
        if (!this.registered) {
            this.comp.registerKeyboardAction(this.leftAction, LeftKey1, 0);
            this.comp.registerKeyboardAction(this.leftAction, LeftKey2, 0);
            this.comp.registerKeyboardAction(this.rightAction, RightKey1, 0);
            this.comp.registerKeyboardAction(this.rightAction, RightKey2, 0);
            this.comp.registerKeyboardAction(this.upAction, UpKey1, 0);
            this.comp.registerKeyboardAction(this.upAction, UpKey2, 0);
            this.comp.registerKeyboardAction(this.downAction, DownKey1, 0);
            this.comp.registerKeyboardAction(this.downAction, DownKey2, 0);
            this.registered = true;
        }
    }

    void unregisterKeys() {
        if (this.registered) {
            this.comp.unregisterKeyboardAction(LeftKey1);
            this.comp.unregisterKeyboardAction(LeftKey2);
            this.comp.unregisterKeyboardAction(RightKey1);
            this.comp.unregisterKeyboardAction(RightKey2);
            this.comp.unregisterKeyboardAction(UpKey1);
            this.comp.unregisterKeyboardAction(UpKey2);
            this.comp.unregisterKeyboardAction(DownKey1);
            this.comp.unregisterKeyboardAction(DownKey2);
            this.registered = false;
        }
    }

    private void moveSelectedCurves(int x, int y) {
        this.model.editStart();
        CurveSelection selection = this.model.getSelection();
        CurveIterator curves = selection.iterator();
        Point2D.Double p1 = new Point2D.Double(0.0, 0.0);
        Point2D.Double p2 = new Point2D.Double(x, y);
        while (curves.hasNext()) {
            this.comp.moveCurve(curves.nextCurve(), p1, p2);
        }
        this.model.editEnd();
    }
}

