/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region;

import com.lightcrafts.ui.region.Curve;
import com.lightcrafts.ui.region.CurveIterator;
import com.lightcrafts.ui.region.CurveSelection;
import com.lightcrafts.ui.region.EditCurveMode;
import com.lightcrafts.ui.region.MinorRegionMode;
import com.lightcrafts.ui.region.RegionMode;
import java.awt.Point;
import java.awt.event.MouseEvent;

class MoveEditingCurveMode
extends MinorRegionMode {
    private Point currentPoint;
    private CurveIterator curves;
    private Curve editingCurve;

    MoveEditingCurveMode(RegionMode oldMode, Curve curve) {
        super(oldMode);
        this.editingCurve = curve;
        CurveSelection selection = this.model.getSelection();
        this.curves = selection.iterator();
        this.comp.setCursor(MovingCurveCursor);
        while (this.curves.hasNext()) {
            this.model.notifyChangeStart(this.curves.nextCurve());
        }
        this.model.editStart();
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.model.setMajorMode(new EditCurveMode(this, this.editingCurve));
        if (this.currentPoint != null) {
            this.model.editEnd();
        } else {
            this.model.editCancel();
        }
        Point p = event.getPoint();
        this.update(p, false);
        this.curves.reset();
        while (this.curves.hasNext()) {
            this.model.notifyChangeEnd(this.curves.nextCurve());
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        Point p = event.getPoint();
        this.update(p, true);
        this.autoscroll(event);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        Point p = event.getPoint();
        this.update(p, true);
        this.autoscroll(event);
    }

    private void update(Point p, boolean isUpdating) {
        if (this.currentPoint != null) {
            this.curves.reset();
            while (this.curves.hasNext()) {
                this.comp.moveCurve(this.curves.nextCurve(), this.currentPoint, p, isUpdating);
            }
        }
        this.currentPoint = p;
    }
}

