/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region;

import com.lightcrafts.ui.region.RegionListener;
import com.lightcrafts.ui.region.SharedShape;
import java.util.Collection;

class RegionChangeMulticaster {
    private RegionListener listener;
    private RegionChangeMulticaster next;

    RegionChangeMulticaster() {
    }

    void add(RegionListener listener) {
        RegionChangeMulticaster multicaster = this;
        while (multicaster.next != null) {
            multicaster = multicaster.next;
        }
        multicaster.listener = listener;
        multicaster.next = new RegionChangeMulticaster();
    }

    void remove(RegionListener listener) {
        RegionChangeMulticaster multicaster = this;
        do {
            if (multicaster.listener != listener) continue;
            multicaster.listener = null;
            if (multicaster.next != null) {
                multicaster.listener = multicaster.next.listener;
                multicaster.next = multicaster.next.next;
            }
            return;
        } while ((multicaster = multicaster.next) != null);
    }

    void regionBatchStart(Collection cookies) {
        if (this.listener != null) {
            for (Object cookie : cookies) {
                this.listener.regionBatchStart(cookie);
            }
            this.next.regionBatchStart(cookies);
        }
    }

    void regionChanged(Collection cookies, SharedShape shape) {
        if (this.listener != null) {
            for (Object cookie : cookies) {
                this.listener.regionChanged(cookie, shape);
            }
            this.next.regionChanged(cookies, shape);
        }
    }

    void regionBatchEnd(Collection cookies) {
        if (this.listener != null) {
            for (Object cookie : cookies) {
                this.listener.regionBatchEnd(cookie);
            }
            this.next.regionBatchEnd(cookies);
        }
    }
}

