/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region.curves;

import com.lightcrafts.ui.region.curves.BasisFunction;
import com.lightcrafts.ui.region.curves.Cubic;
import com.lightcrafts.ui.region.curves.Polynomial;

class CubicBasisFunction
extends BasisFunction {
    CubicBasisFunction(int i) {
        super(i, 3);
    }

    @Override
    Polynomial computeSegment(int j) {
        int i = this.getFirstIndex();
        double t0 = i + 0;
        double t1 = i + 1;
        double t2 = i + 2;
        double t3 = i + 3;
        double t4 = i + 4;
        if (j == i) {
            return Cubic.createFactored(t0, t0, t0).divide(6.0);
        }
        if (j == i + 1) {
            Cubic c1 = Cubic.createFactored(t0, t0, t2);
            Cubic c2 = Cubic.createFactored(t1, t1, t4);
            Cubic c3 = Cubic.createFactored(t0, t1, t3);
            return c1.add(c2.add(c3)).divide(-6.0);
        }
        if (j == i + 2) {
            Cubic c1 = Cubic.createFactored(t0, t3, t3);
            Cubic c2 = Cubic.createFactored(t1, t3, t4);
            Cubic c3 = Cubic.createFactored(t2, t4, t4);
            return c1.add(c2.add(c3)).divide(6.0);
        }
        if (j == i + 3) {
            return Cubic.createFactored(t4, t4, t4).divide(-6.0);
        }
        return new Cubic(0.0, 0.0, 0.0, 0.0);
    }
}

