/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region.curves;

import java.awt.BasicStroke;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

class InnerShape {
    private static Shape Shape;
    private static ArrayList Blurs;
    private static final String[] PathTypeNames;

    InnerShape() {
    }

    static float getWidth(Shape outer, Point2D p) {
        if (!outer.contains(p)) {
            return 0.0f;
        }
        Rectangle bounds = outer.getBounds();
        int maxDim = Math.max(bounds.width, bounds.height) / 2;
        if (Shape != outer) {
            Blurs.clear();
            Shape = outer;
        }
        for (int w = 0; w < maxDim; ++w) {
            Shape blur;
            if (Blurs.size() <= w) {
                BasicStroke stroke = new BasicStroke(2 * (w + 1), 1, 1);
                Shape blur2 = stroke.createStrokedShape(outer);
                Blurs.add(blur2);
            }
            if (!(blur = (Shape)Blurs.get(w)).contains(p)) continue;
            return w;
        }
        return 0.0f;
    }

    static Shape getInnerShape(Shape outer, float width) {
        BasicStroke stroke = new BasicStroke(2.0f * width, 1, 1);
        Shape thickShape = stroke.createStrokedShape(outer);
        Area inner = new Area(outer);
        inner.subtract(new Area(thickShape));
        return InnerShape.getFilteredShape(inner);
    }

    static float getDefaultWidth(Shape outer) {
        float thickness = InnerShape.getThickness(outer);
        return thickness * 0.2f;
    }

    static float getDefaultWidth(Shape outer, float width) {
        float thickness = width / 0.2f;
        thickness = InnerShape.getThickness(outer, thickness);
        return thickness * 0.2f;
    }

    private static float getThickness(Shape shape) {
        return InnerShape.getThickness(shape, 0.0f, InnerShape.getThicknessBound(shape));
    }

    private static float getThickness(Shape shape, float min, float max) {
        float thickness = (max + min) / 2.0f;
        while (max - min > 2.0f) {
            Shape inner = InnerShape.getInnerShape(shape, thickness);
            double size = InnerShape.getCharacteristicSize(inner);
            if (size > 0.0) {
                min = thickness;
            } else {
                max = thickness;
            }
            thickness = (max + min) / 2.0f;
        }
        return thickness;
    }

    private static float getThickness(Shape shape, float thickness) {
        float min = 0.0f;
        float max = InnerShape.getThicknessBound(shape);
        Shape inner = InnerShape.getInnerShape(shape, thickness);
        double size = InnerShape.getCharacteristicSize(inner);
        if (size > 0.0) {
            min = thickness;
            float delta = 2.0f;
            while (size > 0.0 && thickness + delta < max) {
                inner = InnerShape.getInnerShape(shape, thickness += delta);
                size = InnerShape.getCharacteristicSize(inner);
                delta *= 2.0f;
            }
            max = thickness;
        } else {
            max = thickness;
            float delta = 2.0f;
            while (size == 0.0 && thickness - delta > min) {
                inner = InnerShape.getInnerShape(shape, thickness -= delta);
                size = InnerShape.getCharacteristicSize(inner);
                delta *= 2.0f;
            }
            min = thickness;
        }
        return InnerShape.getThickness(shape, min, max);
    }

    private static float getThicknessBound(Shape shape) {
        return InnerShape.getCharacteristicSize(shape) / 2.0f;
    }

    private static float getCharacteristicSize(Shape shape) {
        Rectangle2D bounds = shape.getBounds2D();
        return (float)Math.min(bounds.getWidth(), bounds.getHeight());
    }

    private static Shape getFilteredShape(Shape shape) {
        Set comps = InnerShape.getConnectedComponents(shape);
        GeneralPath filtered = new GeneralPath();
        for (Shape comp : comps) {
            Rectangle2D compRect = comp.getBounds2D();
            int compSize = (int)Math.min(compRect.getWidth(), compRect.getHeight());
            if (compSize <= 0) continue;
            filtered.append(comp, false);
        }
        return filtered;
    }

    private static Set getConnectedComponents(Shape shape) {
        PathIterator i = shape.getPathIterator(new AffineTransform());
        HashSet<GeneralPath> components = new HashSet<GeneralPath>();
        if (i.isDone()) {
            return components;
        }
        float[] pts = new float[6];
        GeneralPath component = new GeneralPath();
        int type = i.currentSegment(pts);
        assert (type == 0);
        component.moveTo(pts[0], pts[1]);
        i.next();
        while (!i.isDone()) {
            type = i.currentSegment(pts);
            if (type == 0) {
                components.add(component);
                component = new GeneralPath();
                component.moveTo(pts[0], pts[1]);
            } else if (type == 1) {
                component.lineTo(pts[0], pts[1]);
            } else if (type == 2) {
                component.quadTo(pts[0], pts[1], pts[2], pts[3]);
            } else if (type == 3) {
                component.curveTo(pts[0], pts[1], pts[2], pts[3], pts[4], pts[5]);
            } else if (type == 4) {
                component.closePath();
            }
            i.next();
        }
        components.add(component);
        return components;
    }

    private static String segmentsToString(Shape shape) {
        StringBuffer buffer = new StringBuffer();
        PathIterator i = shape.getPathIterator(new AffineTransform());
        float[] pts = new float[6];
        while (!i.isDone()) {
            int type = i.currentSegment(pts);
            buffer.append(PathTypeNames[type]);
            buffer.append(" ");
            i.next();
        }
        return buffer.toString();
    }

    static {
        Blurs = new ArrayList();
        PathTypeNames = new String[]{"MOVE", "LINE", "QUAD", "CUBIC", "CLOSE"};
    }
}

