/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.rotate;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

class InfiniteLine {
    private Point2D p;
    private double angle;
    private boolean isMoreHorizontal;

    InfiniteLine(double x, double y, double angle) {
        this.p = new Point2D.Double(x, y);
        this.angle = angle;
        this.isMoreHorizontal = Math.abs(Math.sin(angle)) < Math.sqrt(0.5);
    }

    double getY(double x) {
        return this.p.getY() + (x - this.p.getX()) * Math.tan(this.angle);
    }

    double getX(double y) {
        return this.p.getX() + (y - this.p.getY()) / Math.tan(this.angle);
    }

    Line2D getSegment(Rectangle2D rect) {
        if (this.isMoreHorizontal) {
            double x2;
            double x1 = rect.getX();
            Line2D line = this.getHorizontalSegment(x1, x2 = rect.getX() + rect.getWidth());
            if (rect.intersectsLine(line)) {
                return line;
            }
        } else {
            double y2;
            double y1 = rect.getY();
            Line2D line = this.getVerticalSegment(y1, y2 = rect.getY() + rect.getHeight());
            if (rect.intersectsLine(line)) {
                return line;
            }
        }
        return null;
    }

    boolean intersects(Rectangle2D rect) {
        return this.getSegment(rect) != null;
    }

    private Line2D getHorizontalSegment(double x1, double x2) {
        double y1 = this.getY(x1);
        double y2 = this.getY(x2);
        return new Line2D.Double(x1, y1, x2, y2);
    }

    private Line2D getVerticalSegment(double y1, double y2) {
        double x1 = this.getX(y1);
        double x2 = this.getX(y2);
        return new Line2D.Double(x1, y1, x2, y2);
    }
}

