/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.rotate;

import com.lightcrafts.ui.rotate.Locale;
import com.lightcrafts.ui.rotate.RotorControl;
import com.lightcrafts.ui.rotate.RotorListener;
import com.lightcrafts.ui.toolkit.LCSliderUI;
import java.awt.Font;
import java.util.LinkedList;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class MinorRotorSlider
extends JSlider {
    private LinkedList<RotorListener> listeners;
    private boolean restoring;

    MinorRotorSlider() {
        super(-50, 50);
        this.setUI(new LCSliderUI(this));
        this.setToolTipText(Locale.LOCALE.get("MinorRotorToolTip"));
        this.setMajorTickSpacing(25);
        this.setMinorTickSpacing(5);
        this.setPaintTicks(true);
        this.setFont(new Font("Lucida Grande", 0, 9));
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                if (!MinorRotorSlider.this.restoring) {
                    double angle = MinorRotorSlider.this.getAngle();
                    boolean isChanging = MinorRotorSlider.this.getValueIsAdjusting();
                    MinorRotorSlider.this.notifyListeners(angle, isChanging);
                }
            }
        });
        this.listeners = new LinkedList();
    }

    double getAngle() {
        int value = this.getValue();
        double angle = RotorControl.degreesToRadians(value);
        return angle / 100.0;
    }

    void setAngle(double angle) {
        int value = (int)Math.round(100.0 * RotorControl.radiansToDegrees(angle));
        this.restoring = true;
        this.setValue(value);
        this.restoring = false;
    }

    double getDegrees() {
        return (double)this.getValue() / 100.0;
    }

    void setDegrees(double degrees) {
        double radians = RotorControl.degreesToRadians(degrees);
        this.setAngle(radians);
    }

    void addRotorListener(RotorListener listener) {
        this.listeners.add(listener);
    }

    void removeRotorListener(RotorListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(double angle, boolean isChanging) {
        for (RotorListener listener : this.listeners) {
            listener.angleChanged(angle, isChanging, false);
        }
    }
}

