/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.swing;

import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.swing.RangeSelectorColorGradientTrack;
import com.lightcrafts.ui.swing.RangeSelectorModel;
import com.lightcrafts.ui.toolkit.ShadowFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RangeSelector
extends JComponent {
    protected transient ChangeEvent m_changeEvent;
    private Shape m_hoverPolygon;
    private boolean m_inDrag;
    private boolean m_stateChanged;
    private RangeSelectorModel m_model;
    private Polygon[] m_polygons;
    private Track m_track;
    private boolean m_trackValueWraps;
    private static final BufferedImage[] m_images = new BufferedImage[2];
    private static final Color ARROW_COLOR = Color.LIGHT_GRAY;
    private static final int ARROW_HEIGHT = 9;
    private static final int ARROW_WIDTH = 5;
    private static final Color HOVER_COLOR = new Color(Color.LIGHT_GRAY.getRed(), Color.LIGHT_GRAY.getGreen(), Color.LIGHT_GRAY.getBlue(), 128);
    private static final int SHADOW_FUDGE_X = 3;
    private static final int SHADOW_FUDGE_Y = 2;
    private static final Color THUMB_DARK_COLOR = new Color(110, 110, 110);
    private static final Color THUMB_LIGHT_COLOR = new Color(185, 185, 185);
    private static final Color THUMB_SHADOW_COLOR = new Color(25, 25, 25);
    private static final int THUMB_HEIGHT = 9;
    private static final int THUMB_WIDTH = 14;
    private static final int THUMB_INDEX_START = 0;
    private static final int THUMB_INDEX_END = 3;
    private static final int LOWER_FEATHERING_THUMB = 0;
    private static final int LOWER_THUMB = 1;
    private static final int UPPER_THUMB = 2;
    private static final int UPPER_FEATHERING_THUMB = 3;
    private static final int TRACK = 4;
    private static final int LOWER_SCROLL_ARROW = 5;
    private static final int UPPER_SCROLL_ARROW = 6;

    public RangeSelector() {
        this(new RangeSelectorModel(), false);
    }

    public RangeSelector(int minimumThumbValue, int maximumThumbValue) {
        this(minimumThumbValue, maximumThumbValue, minimumThumbValue, minimumThumbValue, maximumThumbValue, maximumThumbValue);
    }

    public RangeSelector(int minimumThumbValue, int maximumThumbValue, int lowerThumbValue, int lowerFeatheringValue, int upperThumbValue, int upperThumbFeatheringValue) {
        this(new RangeSelectorModel(minimumThumbValue, maximumThumbValue, lowerThumbValue, lowerFeatheringValue, upperThumbValue, upperThumbFeatheringValue, 0, Integer.MAX_VALUE, 0), false);
    }

    public RangeSelector(int minimumThumbValue, int maximumThumbValue, int lowerThumbValue, int lowerFeatheringValue, int upperThumbValue, int upperThumbFeatheringValue, int minimumTrackValue, int maximumTrackValue, int trackValue, boolean trackValueWraps) {
        this(new RangeSelectorModel(minimumThumbValue, maximumThumbValue, lowerThumbValue, lowerFeatheringValue, upperThumbValue, upperThumbFeatheringValue, minimumTrackValue, maximumTrackValue, trackValue), trackValueWraps);
    }

    public RangeSelector(RangeSelectorModel model, boolean trackValueWraps) {
        this.m_model = model;
        this.m_trackValueWraps = trackValueWraps;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                RangeSelector.this.stateChanged();
            }
        });
        this.setFocusable(false);
        LocalMouseListener listener = new LocalMouseListener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public int getTrackValue() {
        return this.m_model.getTrackValue();
    }

    public boolean getTrackValueWraps() {
        return this.m_trackValueWraps;
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    public int getLowerThumbFeatheringValue() {
        return this.m_model.getLowerThumbFeatheringValue();
    }

    public int getLowerThumbFeatheringValueX() {
        return this.m_polygons[0].xpoints[0];
    }

    public int getLowerThumbValue() {
        return this.m_model.getLowerThumbValue();
    }

    public int getLowerThumbValueX() {
        return this.m_polygons[1].xpoints[0];
    }

    public int getMaximumThumbValue() {
        return this.m_model.getMaximumThumbValue();
    }

    @Override
    public Dimension getMaximumSize() {
        Insets in = this.getInsets();
        return new Dimension(Integer.MAX_VALUE, in.top + in.bottom + Math.max(9, 9));
    }

    public int getMaximumTrackValue() {
        return this.m_model.getMaximumTrackValue();
    }

    public int getMinimumThumbValue() {
        return this.m_model.getMinimumThumbValue();
    }

    @Override
    public Dimension getMinimumSize() {
        Insets in = this.getInsets();
        return new Dimension(100, in.top + in.bottom + Math.max(9, 9));
    }

    public int getMinimumTrackValue() {
        return this.m_model.getMinimumTrackValue();
    }

    public RangeSelectorModel getModel() {
        return this.m_model;
    }

    @Override
    public Dimension getPreferredSize() {
        int modelWidth = this.m_model.getMaximumThumbValue() - this.m_model.getMinimumThumbValue();
        Insets in = this.getInsets();
        return new Dimension(modelWidth + in.left + in.right + 10 + 14, in.top + in.bottom + Math.max(9, 9));
    }

    public Track getTrack() {
        return this.m_track;
    }

    public int getUpperThumbFeatheringValue() {
        return this.m_model.getUpperThumbFeatheringValue();
    }

    public int getUpperThumbFeatheringValueX() {
        return this.m_polygons[3].xpoints[0];
    }

    public int getUpperThumbValue() {
        return this.m_model.getUpperThumbValue();
    }

    public int getUpperThumbValueX() {
        return this.m_polygons[2].xpoints[0];
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    public void setLowerThumbFeatheringValue(int newValue) {
        if (this.m_model.setLowerFeatheringValue(newValue)) {
            this.fireStateChanged();
        }
    }

    public void setLowerThumbValue(int newValue) {
        if (this.m_model.setLowerThumbValue(newValue)) {
            this.fireStateChanged();
        }
    }

    public void setMaximumThumbValue(int newValue) {
        if (this.m_model.setMaximumThumbValue(newValue)) {
            this.fireStateChanged();
        }
    }

    public void setMinimumThumbValue(int newValue) {
        if (this.m_model.setMinimumThumbValue(newValue)) {
            this.fireStateChanged();
        }
    }

    public void setModel(RangeSelectorModel newModel) {
        if (newModel != this.m_model) {
            this.m_model = newModel;
            this.fireStateChanged();
        }
    }

    public void setProperties(int minimumThumbValue, int maximumThumbValue, int lowerThumbValue, int lowerThumbFeatheringValue, int upperThumbValue, int upperThumbFeatheringValue, int minimumTrackValue, int maximumTrackValue, int trackValue, boolean trackValueWraps) {
        boolean changed = this.m_model.setThumbProperties(minimumThumbValue, maximumThumbValue, lowerThumbValue, lowerThumbFeatheringValue, upperThumbValue, upperThumbFeatheringValue);
        boolean bl = changed = this.m_model.setTrackProperties(minimumTrackValue, maximumTrackValue, trackValue) || changed;
        if (changed) {
            this.fireStateChanged();
        }
    }

    public void setTrack(Track t) {
        this.m_track = t;
    }

    public void setTrackValue(int newValue) {
        if (this.m_model.setTrackValue(newValue)) {
            this.fireStateChanged();
        }
    }

    public void setUpperThumbFeatheringValue(int newValue) {
        if (this.m_model.setUpperThumbFeatheringValue(newValue)) {
            this.fireStateChanged();
        }
    }

    public void setUpperThumbValue(int newValue) {
        if (this.m_model.setUpperThumbValue(newValue)) {
            this.fireStateChanged();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.m_polygons == null) {
            this.positionPolygons();
            if (this.m_polygons == null) {
                return;
            }
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.isOpaque()) {
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        Insets in = this.getInsets();
        Rectangle trackRect = new Rectangle(this.getMinimumThumbX(), in.top, this.getWidth() - in.left - in.right - 10 - 14, this.getHeight() - in.top - in.bottom);
        this.m_track.paintTrack(this, trackRect, g2d);
        g2d.setColor(Color.BLACK);
        for (int i = 0; i <= 3; ++i) {
            Rectangle r = this.m_polygons[i].getBounds();
            g2d.drawImage(m_images[i % 2], null, r.x, r.y);
        }
        if (this.m_trackValueWraps) {
            g2d.setColor(ARROW_COLOR);
            g2d.fill(this.m_polygons[5]);
            g2d.fill(this.m_polygons[6]);
        }
        for (Polygon s : this.m_polygons) {
            if (s != this.m_hoverPolygon) continue;
            g2d.setColor(HOVER_COLOR);
            g2d.draw(s);
            break;
        }
    }

    private static Polygon[] createPolygons() {
        Polygon[] p = new Polygon[7];
        p[0] = new Polygon(new int[]{0, 0, -7}, new int[]{0, 9, 0}, 3);
        p[1] = new Polygon(new int[]{0, 0, 7}, new int[]{0, 9, 0}, 3);
        p[2] = new Polygon(new int[]{0, 0, -7}, new int[]{0, 9, 0}, 3);
        p[3] = new Polygon(new int[]{0, 0, 7}, new int[]{0, 9, 0}, 3);
        p[5] = new Polygon(new int[]{0, 5, 5}, new int[]{4, 0, 9}, 3);
        p[6] = new Polygon(new int[]{0, -5, -5}, new int[]{4, 0, 9}, 3);
        return p;
    }

    private Shape findPolygon(Point p) {
        int i = this.findPolygonIndex(p);
        return i >= 0 ? this.m_polygons[i] : null;
    }

    private int findPolygonIndex(Point p) {
        block3: for (int i = 0; i < this.m_polygons.length; ++i) {
            if (!this.m_polygons[i].getBounds().contains(p)) continue;
            switch (i) {
                case 5: 
                case 6: {
                    if (!this.m_trackValueWraps) continue block3;
                }
                default: {
                    return i;
                }
            }
        }
        return -1;
    }

    private void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.m_changeEvent == null) {
                this.m_changeEvent = new ChangeEvent(this);
            }
            ChangeListener listener = (ChangeListener)listeners[i + 1];
            listener.stateChanged(this.m_changeEvent);
        }
        this.stateChanged();
    }

    private int getMaximumThumbX() {
        Insets in = this.getInsets();
        return this.getWidth() - in.right - 1 - 5 - 7;
    }

    private int getMinimumThumbX() {
        Insets in = this.getInsets();
        return in.left + 5 + 7;
    }

    private double getThumbXScale() {
        double modelWidth = this.m_model.getMaximumThumbValue() - this.m_model.getMinimumThumbValue();
        Insets in = this.getInsets();
        return (double)(this.getWidth() - in.left - in.right - 10 - 14) / modelWidth;
    }

    private static void initImages() {
        Polygon triangle = new Polygon(new int[]{0, 14, 7}, new int[]{0, 0, 9}, 3);
        BufferedImage buf = new BufferedImage(14, 11, 2);
        Graphics2D g2d = (Graphics2D)buf.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GradientPaint p = new GradientPaint(0.0f, 0.0f, THUMB_LIGHT_COLOR, 7.0f, 0.0f, THUMB_DARK_COLOR);
        g2d.setPaint(p);
        g2d.fill(triangle);
        g2d.dispose();
        Raster[] raster = new Raster[]{buf.getData(new Rectangle(0, 0, 7, 9)), buf.getData(new Rectangle(7, 0, 7, 9))};
        raster[1] = raster[1].createTranslatedChild(0, 0);
        ShadowFactory sf = new ShadowFactory(4, 0.6f, THUMB_SHADOW_COLOR);
        sf.setRenderingHint("blur_quality", "high");
        for (int i = 0; i < 2; ++i) {
            RangeSelector.m_images[i] = new BufferedImage(buf.getColorModel(), (WritableRaster)raster[i], false, null);
            BufferedImage temp = sf.createShadow(m_images[i]);
            temp = temp.getSubimage(3, 2, temp.getWidth() - 3, temp.getHeight() - 2);
            g2d = (Graphics2D)temp.getGraphics();
            g2d.drawRenderedImage(m_images[i], new AffineTransform());
            RangeSelector.m_images[i] = temp;
            g2d.dispose();
        }
    }

    private int mapThumbValueToX(int value) {
        int minV = this.getMinimumThumbValue();
        return this.getMinimumThumbX() + (int)((double)(value - minV) * this.getThumbXScale() + 0.5);
    }

    private int mapXToThumbValue(int x) {
        int minV = this.getMinimumThumbValue();
        int maxV = this.getMaximumThumbValue();
        int minX = this.getMinimumThumbX();
        int maxX = this.getMaximumThumbX();
        if (x < minX) {
            return minV - 1;
        }
        if (x > maxX) {
            return maxV + 1;
        }
        return minV + (int)((double)(x - minX) / this.getThumbXScale() + 0.5);
    }

    private void movePolygonTo(int polygonIndex, int x) {
        RangeSelector.movePolygonTo(this.m_polygons[polygonIndex], x);
    }

    private static void movePolygonTo(Polygon p, int x) {
        p.translate(x - p.xpoints[0], 0);
    }

    private void positionPolygons() {
        this.m_polygons = null;
        if (this.getWidth() == 0) {
            return;
        }
        int ltfv = this.m_model.getLowerThumbFeatheringValue();
        int ltv = this.m_model.getLowerThumbValue();
        int utv = this.m_model.getUpperThumbValue();
        int utfv = this.m_model.getUpperThumbFeatheringValue();
        int ltfvx = this.mapThumbValueToX(ltfv);
        int ltvx = this.mapThumbValueToX(ltv);
        int utvx = this.mapThumbValueToX(utv);
        int utfvx = this.mapThumbValueToX(utfv);
        int y = this.getHeight() / 2 - 4;
        this.m_polygons = RangeSelector.createPolygons();
        this.m_polygons[0].translate(ltfvx, y);
        this.m_polygons[1].translate(ltvx, y);
        this.m_polygons[2].translate(utvx, y);
        this.m_polygons[3].translate(utfvx, y);
        Insets in = this.getInsets();
        int minX = this.getMinimumThumbX();
        int maxX = this.getMaximumThumbX();
        int minY = in.top;
        int maxY = minY + 9 - 1;
        this.m_polygons[4] = new Polygon(new int[]{minX, maxX, maxX, minX}, new int[]{minY, minY, maxY, maxY}, 4);
        this.m_polygons[5].translate(in.left, y);
        this.m_polygons[6].translate(this.getWidth() - in.right, y);
    }

    private void stateChanged() {
        this.positionPolygons();
        this.repaint();
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(Platform.getPlatform().getLookAndFeel());
        final RangeSelector rs = new RangeSelector(0, 100, 0, 0, 100, 100, 0, 100, 0, true);
        rs.setTrack(new RangeSelectorColorGradientTrack());
        JPanel customLayout = new JPanel(null){

            @Override
            public Dimension getPreferredSize() {
                return rs.getPreferredSize();
            }

            @Override
            public void doLayout() {
                Dimension size = this.getSize();
                int midY = size.height / 2;
                Dimension pSize = rs.getPreferredSize();
                int pHeight = pSize.height;
                int y = midY - pHeight / 2;
                rs.setLocation(0, y);
                rs.setSize(size.width, pHeight);
            }
        };
        customLayout.add(rs);
        customLayout.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        JFrame frame = new JFrame("Test");
        frame.getContentPane().add(customLayout);
        frame.setSize(600, 100);
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    static {
        RangeSelector.initImages();
    }

    private final class LocalMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private int m_mousePointX;
        private int m_foundPolygonIndex = -1;
        private Timer m_scrollTimer;
        private static final int CLICK_DELAY = 500;
        private static final int INTER_SCROLL_DELAY = 50;
        private static final int SCROLL_TRACK_DELTA = 5;

        private LocalMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger() || this.ignoreMouseEvent()) {
                return;
            }
            Point p = me.getPoint();
            this.m_mousePointX = p.x;
            this.m_foundPolygonIndex = RangeSelector.this.findPolygonIndex(p);
            switch (this.m_foundPolygonIndex) {
                case 5: 
                case 6: {
                    this.scrollOnce(this.m_foundPolygonIndex);
                    this.startScrollTimer(this.m_foundPolygonIndex);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            this.killScrollTimer();
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            if (this.ignoreMouseEvent() || this.m_foundPolygonIndex == -1) {
                return;
            }
            int newDragPointX = me.getPoint().x;
            RangeSelector.this.m_inDrag = true;
            try {
                switch (this.m_foundPolygonIndex) {
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 4: {
                        this.dragAllThumbs(newDragPointX);
                        break;
                    }
                    default: {
                        this.dragThumb(newDragPointX);
                        break;
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            RangeSelector.this.m_inDrag = false;
        }

        @Override
        public void mouseExited(MouseEvent me) {
            if (RangeSelector.this.m_hoverPolygon != null) {
                RangeSelector.this.m_hoverPolygon = null;
                RangeSelector.this.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            if (this.ignoreMouseEvent()) {
                return;
            }
            Shape oldHoverPolygon = RangeSelector.this.m_hoverPolygon;
            RangeSelector.this.m_hoverPolygon = RangeSelector.this.findPolygon(me.getPoint());
            if (RangeSelector.this.m_hoverPolygon != oldHoverPolygon) {
                RangeSelector.this.repaint();
            }
        }

        private void dragAllThumbs(int newDragPointX) {
            int minX = RangeSelector.this.getMinimumThumbX();
            int maxX = RangeSelector.this.getMaximumThumbX();
            int lfvx = RangeSelector.this.getLowerThumbFeatheringValueX();
            int lvx = RangeSelector.this.getLowerThumbValueX();
            int uvx = RangeSelector.this.getUpperThumbValueX();
            int ufvx = RangeSelector.this.getUpperThumbFeatheringValueX();
            int dx = newDragPointX - this.m_mousePointX;
            int[] newX = new int[5];
            if (dx < 0) {
                newX[0] = lfvx + dx;
                if (newX[0] < minX) {
                    newX[0] = minX;
                    dx = minX - lfvx;
                    newDragPointX = this.m_mousePointX + dx;
                }
                newX[1] = lvx + dx;
                newX[2] = uvx + dx;
                newX[3] = ufvx + dx;
            } else {
                newX[3] = ufvx + dx;
                if (newX[3] > maxX) {
                    newX[3] = maxX;
                    dx = maxX - ufvx;
                    newDragPointX = this.m_mousePointX + dx;
                }
                newX[0] = lfvx + dx;
                newX[1] = lvx + dx;
                newX[2] = uvx + dx;
            }
            int[] newV = new int[4];
            for (int i = 0; i <= 3; ++i) {
                newV[i] = RangeSelector.this.mapXToThumbValue(newX[i]);
                RangeSelector.this.movePolygonTo(i, newX[i]);
            }
            RangeSelector.this.setProperties(RangeSelector.this.getMinimumThumbValue(), RangeSelector.this.getMaximumThumbValue(), newV[1], newV[0], newV[2], newV[3], RangeSelector.this.getMinimumTrackValue(), RangeSelector.this.getMaximumTrackValue(), RangeSelector.this.getTrackValue(), RangeSelector.this.getTrackValueWraps());
            this.m_mousePointX = newDragPointX;
        }

        private void dragThumb(int newDragPointX) {
            int minX = RangeSelector.this.getMinimumThumbX();
            int maxX = RangeSelector.this.getMaximumThumbX();
            int lfvx = RangeSelector.this.getLowerThumbFeatheringValueX();
            int lvx = RangeSelector.this.getLowerThumbValueX();
            int uvx = RangeSelector.this.getUpperThumbValueX();
            int ufvx = RangeSelector.this.getUpperThumbFeatheringValueX();
            int dx = newDragPointX - this.m_mousePointX;
            int newX = 0;
            int partnerIndex = -1;
            int partnerNewX = 0;
            if (dx < 0) {
                switch (this.m_foundPolygonIndex) {
                    case 0: {
                        newX = lfvx + dx;
                        if (newX < minX) {
                            newX = newDragPointX = minX;
                        }
                        int lfv2 = RangeSelector.this.mapXToThumbValue(newX);
                        RangeSelector.this.setLowerThumbFeatheringValue(lfv2);
                        break;
                    }
                    case 1: {
                        newX = lvx + dx;
                        if (newX < minX) {
                            newX = newDragPointX = minX;
                            dx = minX - lvx;
                        }
                        int lv2 = RangeSelector.this.mapXToThumbValue(newX);
                        if (lfvx > minX) {
                            partnerNewX = lfvx + dx;
                            if (partnerNewX < minX) {
                                partnerNewX = minX;
                            }
                            int lfv2 = RangeSelector.this.mapXToThumbValue(partnerNewX);
                            try {
                                RangeSelector.this.setLowerThumbFeatheringValue(lfv2);
                                partnerIndex = 0;
                            }
                            catch (IllegalArgumentException e) {
                                // empty catch block
                            }
                        }
                        if (RangeSelector.this.getLowerThumbFeatheringValue() > lv2) {
                            RangeSelector.this.setLowerThumbFeatheringValue(lv2);
                            partnerIndex = 0;
                        }
                        RangeSelector.this.setLowerThumbValue(lv2);
                        break;
                    }
                    case 2: {
                        newX = uvx + dx;
                        if (newX < lvx + 14) {
                            newX = newDragPointX = lvx + 14 + 1;
                            dx = newX - uvx;
                        }
                        partnerIndex = 3;
                        partnerNewX = ufvx + dx;
                        int uv2 = RangeSelector.this.mapXToThumbValue(newX);
                        int ufv2 = RangeSelector.this.mapXToThumbValue(partnerNewX);
                        RangeSelector.this.setUpperThumbValue(uv2);
                        RangeSelector.this.setUpperThumbFeatheringValue(ufv2);
                        break;
                    }
                    case 3: {
                        newX = ufvx + dx;
                        int ufv2 = RangeSelector.this.mapXToThumbValue(newX);
                        if (newX <= uvx) {
                            if (newX < lvx + 14) {
                                newDragPointX = newX = lvx + 14 + 1;
                                ufv2 = RangeSelector.this.mapXToThumbValue(newX);
                            }
                            RangeSelector.this.setUpperThumbValue(ufv2);
                            partnerIndex = 2;
                            partnerNewX = newX;
                        }
                        RangeSelector.this.setUpperThumbFeatheringValue(ufv2);
                        break;
                    }
                }
            } else {
                switch (this.m_foundPolygonIndex) {
                    case 0: {
                        newX = lfvx + dx;
                        int lfv2 = RangeSelector.this.mapXToThumbValue(newX);
                        if (newX >= lvx) {
                            if (newX >= uvx - 14) {
                                newDragPointX = newX = uvx - 14 - 1;
                                lfv2 = RangeSelector.this.mapXToThumbValue(newX);
                            }
                            RangeSelector.this.setLowerThumbValue(lfv2);
                            partnerIndex = 1;
                            partnerNewX = newX;
                        }
                        RangeSelector.this.setLowerThumbFeatheringValue(lfv2);
                        break;
                    }
                    case 1: {
                        newX = lvx + dx;
                        if (newX > uvx - 14) {
                            newX = newDragPointX = uvx - 14 - 1;
                            dx = newX - lvx;
                        }
                        partnerIndex = 0;
                        partnerNewX = lfvx + dx;
                        int lv2 = RangeSelector.this.mapXToThumbValue(newX);
                        int lfv2 = RangeSelector.this.mapXToThumbValue(partnerNewX);
                        RangeSelector.this.setLowerThumbValue(lv2);
                        RangeSelector.this.setLowerThumbFeatheringValue(lfv2);
                        break;
                    }
                    case 2: {
                        newX = uvx + dx;
                        if (newX > maxX) {
                            newX = newDragPointX = maxX;
                            dx = maxX - uvx;
                        }
                        int uv2 = RangeSelector.this.mapXToThumbValue(newX);
                        if (ufvx < maxX) {
                            partnerNewX = ufvx + dx;
                            if (partnerNewX > maxX) {
                                partnerNewX = maxX;
                            }
                            int ufv2 = RangeSelector.this.mapXToThumbValue(partnerNewX);
                            try {
                                RangeSelector.this.setUpperThumbFeatheringValue(ufv2);
                                partnerIndex = 3;
                            }
                            catch (IllegalArgumentException e) {
                                // empty catch block
                            }
                        }
                        if (RangeSelector.this.getUpperThumbFeatheringValue() < uv2) {
                            RangeSelector.this.setUpperThumbFeatheringValue(uv2);
                            partnerIndex = 3;
                        }
                        RangeSelector.this.setUpperThumbValue(uv2);
                        break;
                    }
                    case 3: {
                        newX = ufvx + dx;
                        if (newX > maxX) {
                            newX = newDragPointX = maxX;
                        }
                        int ufv2 = RangeSelector.this.mapXToThumbValue(newX);
                        RangeSelector.this.setUpperThumbFeatheringValue(ufv2);
                        break;
                    }
                }
            }
            RangeSelector.this.movePolygonTo(this.m_foundPolygonIndex, newX);
            if (partnerIndex != -1) {
                RangeSelector.this.movePolygonTo(partnerIndex, partnerNewX);
            }
            this.m_mousePointX = newDragPointX;
        }

        private boolean ignoreMouseEvent() {
            return !RangeSelector.this.isEnabled() || RangeSelector.this.m_polygons == null;
        }

        private void killScrollTimer() {
            if (this.m_scrollTimer != null) {
                this.m_scrollTimer.stop();
                this.m_scrollTimer = null;
            }
        }

        private void scrollOnce(int polygonIndex) {
            int tMin = RangeSelector.this.getMinimumTrackValue();
            int tMax = RangeSelector.this.getMaximumTrackValue();
            int tv = RangeSelector.this.getTrackValue();
            switch (polygonIndex) {
                case 5: {
                    if ((tv += 5) <= tMax) break;
                    tv -= tMax;
                    break;
                }
                case 6: {
                    if ((tv -= 5) >= tMin) break;
                    tv += tMax;
                }
            }
            RangeSelector.this.setTrackValue(tv);
        }

        private void startScrollTimer(final int polygonIndex) {
            ActionListener listener = new ActionListener(){
                boolean m_firstTime = true;

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (this.m_firstTime) {
                        this.m_firstTime = false;
                    } else {
                        LocalMouseListener.this.scrollOnce(polygonIndex);
                    }
                }
            };
            this.m_scrollTimer = new Timer(50, listener);
            this.m_scrollTimer.setCoalesce(true);
            this.m_scrollTimer.setInitialDelay(500);
            this.m_scrollTimer.start();
        }
    }

    public static interface Track {
        public void paintTrack(RangeSelector var1, Rectangle var2, Graphics2D var3);
    }
}

