/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.templates;

import com.lightcrafts.templates.TemplateDatabase;
import com.lightcrafts.templates.TemplateKey;
import com.lightcrafts.ui.templates.Locale;
import com.lightcrafts.ui.templates.TemplateTree;
import com.lightcrafts.ui.toolkit.CoolButton;
import com.lightcrafts.ui.toolkit.IconFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;

class MinusButton
extends CoolButton {
    private static Icon Icon = IconFactory.createInvertedIcon(MinusButton.class, "minus.png");
    private static final String ToolTip = Locale.LOCALE.get("MinusToolTip");

    MinusButton() {
        this.setIcon(Icon);
        this.setToolTipText(ToolTip);
        this.setEnabled(false);
    }

    MinusButton(final TemplateTree tree) {
        this();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TemplateKey key = tree.getSelectedTemplateKey();
                if (key != null) {
                    try {
                        tree.clearSelection();
                        TemplateDatabase.removeTemplateDocument(key);
                    }
                    catch (TemplateDatabase.TemplateException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }
}

