/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.templates;

import com.lightcrafts.app.Application;
import com.lightcrafts.platform.FileChooser;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.templates.TemplateDatabase;
import com.lightcrafts.templates.TemplateKey;
import com.lightcrafts.ui.templates.Locale;
import com.lightcrafts.utils.xml.XmlDocument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TemplateList
extends JPanel
implements ListSelectionListener {
    private static final Preferences Prefs = Preferences.userRoot().node("/com/lightcrafts/ui/templates");
    private static final String RecentImportKey = "TemplateImportDir";
    private static final String RecentExportKey = "TemplateExportDir";
    private JList list;
    private JButton importButton;
    private JButton exportButton;
    private JButton deleteButton;

    private TemplateList() {
        this.setLayout(new BorderLayout());
        this.list = new JList(new DefaultListModel());
        this.list.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.list.addListSelectionListener(this);
        this.add(new JScrollPane(this.list));
        this.updateFromTemplates();
        final FileChooser chooser = Platform.getPlatform().getFileChooser();
        this.importButton = new JButton(Locale.LOCALE.get("TemplateImportButton"));
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Frame frame = TemplateList.this.getAncestorFrame();
                File dir = TemplateList.this.getRecentImportDir();
                FilenameFilter lztFilter = new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String name) {
                        return name.toLowerCase().endsWith(".lzt");
                    }
                };
                File file = chooser.openFile(Locale.LOCALE.get("TemplateImportDialogTitle"), dir, frame, lztFilter);
                if (file != null) {
                    TemplateList.this.importTemplate(file);
                    TemplateList.this.setRecentImportDir(file.getParentFile());
                }
            }
        });
        this.exportButton = new JButton(Locale.LOCALE.get("TemplateExportButton"));
        this.exportButton.setEnabled(false);
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Frame frame = TemplateList.this.getAncestorFrame();
                File dir = TemplateList.this.getRecentExportDir();
                File file = chooser.chooseDirectory(Locale.LOCALE.get("TemplateExportDialogTitle"), dir, frame, false);
                if (file != null) {
                    TemplateList.this.exportTemplates(file);
                    TemplateList.this.setRecentExportDir(file);
                }
            }
        });
        this.deleteButton = new JButton("Delete");
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                List keys = TemplateList.this.getSelectedTemplateKeys();
                DefaultListModel model = (DefaultListModel)TemplateList.this.list.getModel();
                for (TemplateKey key : keys) {
                    try {
                        TemplateDatabase.removeTemplateDocument(key);
                        model.removeElement(key);
                    }
                    catch (TemplateDatabase.TemplateException e) {
                        TemplateList.this.showError(Locale.LOCALE.get("TemplateDeleteError"), e);
                    }
                }
            }
        });
    }

    private void updateFromTemplates() {
        try {
            List<TemplateKey> keys = TemplateDatabase.getTemplateKeys();
            if (!keys.isEmpty()) {
                DefaultListModel<TemplateKey> model = new DefaultListModel<TemplateKey>();
                for (TemplateKey key : keys) {
                    model.addElement(key);
                }
                this.list.setModel(model);
                this.list.setEnabled(true);
            } else {
                DefaultListModel model = (DefaultListModel)this.list.getModel();
                model.removeAllElements();
                model.addElement(Locale.LOCALE.get("NoTemplatesMessage"));
                this.list.setEnabled(false);
            }
        }
        catch (TemplateDatabase.TemplateException e) {
            DefaultListModel model = (DefaultListModel)this.list.getModel();
            model.removeAllElements();
            model.addElement(Locale.LOCALE.get("TemplateStoreError"));
            this.list.setEnabled(false);
        }
    }

    private List<TemplateKey> getSelectedTemplateKeys() {
        Object[] rows = this.list.getSelectedValues();
        ArrayList<TemplateKey> keys = new ArrayList<TemplateKey>();
        for (Object row : rows) {
            TemplateKey key = (TemplateKey)row;
            keys.add(key);
        }
        return keys;
    }

    private void importTemplate(File file) {
        XmlDocument doc;
        try {
            FileInputStream in = new FileInputStream(file);
            doc = new XmlDocument(in);
        }
        catch (IOException e) {
            this.showError(Locale.LOCALE.get("TemplateImportError", file.getName()), e);
            return;
        }
        TemplateKey key = TemplateKey.importKey(file);
        try {
            TemplateDatabase.addTemplateDocument(doc, key, false);
        }
        catch (TemplateDatabase.TemplateException e) {
            this.showError(Locale.LOCALE.get("TemplateStoreError", key.toString()), e);
            return;
        }
        this.updateFromTemplates();
    }

    private void exportTemplates(File dir) {
        if (dir.isFile()) {
            dir = dir.getParentFile();
        }
        List<TemplateKey> keys = this.getSelectedTemplateKeys();
        for (TemplateKey key : keys) {
            XmlDocument doc;
            try {
                doc = TemplateDatabase.getTemplateDocument(key);
            }
            catch (TemplateDatabase.TemplateException e) {
                this.showError(Locale.LOCALE.get("TemplateAccessSpecificError", key.toString()), e);
                continue;
            }
            File file = new File(dir, key + ".lzt");
            try {
                FileOutputStream out = new FileOutputStream(file);
                doc.write(out);
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                this.showError(Locale.LOCALE.get("TemplateWriteError", key.toString(), file.getName()), e);
                return;
            }
            Platform.getPlatform().getAlertDialog().showAlert(this.getAncestorFrame(), Locale.LOCALE.get("TemplateWriteSuccess", key.toString(), file.getName()), "", 1, Locale.LOCALE.get("TemplateWriteOkButton"));
        }
    }

    private void showError(String message, Throwable t) {
        Frame frame = this.getAncestorFrame();
        Application.showError(message, t, frame);
    }

    private Frame getAncestorFrame() {
        return (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
    }

    private File getRecentImportDir() {
        String path = Prefs.get(RecentImportKey, new File(System.getProperty("user.home")).getAbsolutePath());
        return new File(path);
    }

    private void setRecentImportDir(File dir) {
        String path = dir.getAbsolutePath();
        Prefs.put(RecentImportKey, path);
    }

    private File getRecentExportDir() {
        String path = Prefs.get(RecentExportKey, new File(System.getProperty("user.home")).getAbsolutePath());
        return new File(path);
    }

    private void setRecentExportDir(File dir) {
        String path = dir.getAbsolutePath();
        Prefs.put(RecentExportKey, path);
    }

    public static void showDialog(Frame parent) {
        TemplateList templates = new TemplateList();
        JOptionPane.showOptionDialog(parent, templates, Locale.LOCALE.get("TemplateDialogTitle"), 0, -1, null, new Object[]{Locale.LOCALE.get("TemplateDoneButton"), templates.deleteButton, templates.importButton, templates.exportButton}, Locale.LOCALE.get("TemplateDoneButton"));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            boolean empty = this.list.getSelectedValue() == null;
            this.exportButton.setEnabled(!empty);
            this.deleteButton.setEnabled(!empty);
        }
    }

    public static void main(String[] args) {
        TemplateList.showDialog(null);
    }
}

