/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.templates;

import com.lightcrafts.templates.TemplateDatabase;
import com.lightcrafts.templates.TemplateKey;
import com.lightcrafts.ui.templates.TemplateRootNode;
import com.lightcrafts.ui.templates.TemplateTreeNode;
import com.lightcrafts.utils.xml.XMLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreeNode;

class TemplateNamespaceTreeNode
implements TreeNode {
    private TreeNode root;
    private String namespace;
    private ArrayList<TemplateTreeNode> children;

    TemplateNamespaceTreeNode(TemplateRootNode root, String namespace, List<TemplateKey> all) throws XMLException, TemplateDatabase.TemplateException {
        this.root = root;
        this.namespace = namespace;
        this.children = new ArrayList();
        for (TemplateKey key : all) {
            String ns = key.getNamespace();
            if (!ns.equals(namespace)) continue;
            TemplateTreeNode child = new TemplateTreeNode(this, key);
            this.children.add(child);
        }
    }

    public String toString() {
        return this.namespace;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public TreeNode getParent() {
        return this.root;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public Enumeration children() {
        final Iterator<TemplateTreeNode> iterator = this.children.iterator();
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            public Object nextElement() {
                return iterator.next();
            }
        };
    }
}

