/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.templates;

import com.lightcrafts.templates.TemplateDatabase;
import com.lightcrafts.templates.TemplateKey;
import com.lightcrafts.ui.templates.TemplateNamespaceTreeNode;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.tree.TreeNode;

class TemplateRootNode
implements TreeNode {
    private ArrayList<TemplateNamespaceTreeNode> children;

    TemplateRootNode() throws TemplateDatabase.TemplateException {
        List<TemplateKey> keys = TemplateDatabase.getTemplateKeys();
        LinkedHashSet<String> namespaces = new LinkedHashSet<String>();
        for (TemplateKey key : keys) {
            String namespace = key.getNamespace();
            namespaces.add(namespace);
        }
        this.children = new ArrayList();
        for (String namespace : namespaces) {
            try {
                TemplateNamespaceTreeNode child = new TemplateNamespaceTreeNode(this, namespace, keys);
                this.children.add(child);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public TreeNode getParent() {
        return null;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public Enumeration children() {
        final Iterator<TemplateNamespaceTreeNode> iterator = this.children.iterator();
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            public Object nextElement() {
                return iterator.next();
            }
        };
    }
}

