/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.toolkit;

import com.lightcrafts.ui.toolkit.ShadowFactory;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;

public class DropShadowPanel
extends JPanel
implements PropertyChangeListener {
    private float angle = 45.0f;
    private int distance = 2;
    private int distance_x = 0;
    private int distance_y = 0;
    public BufferedImage shadow = null;
    private ShadowFactory factory = null;

    public DropShadowPanel() {
        this(new ShadowFactory(), new FlowLayout());
    }

    public DropShadowPanel(LayoutManager layout) {
        this(new ShadowFactory(), layout);
    }

    public DropShadowPanel(ShadowFactory factory, LayoutManager layout) {
        super(layout);
        this.computeShadowPosition();
        this.setShadowFactory(factory);
    }

    public ShadowFactory getShadowFactory() {
        return this.factory;
    }

    public void setShadowFactory(ShadowFactory factory) {
        if (factory == null) {
            factory = new ShadowFactory();
        }
        if (factory != this.factory) {
            if (this.factory != null) {
                this.factory.removePropertyChangeListener(this);
            }
            this.factory = factory;
            this.factory.addPropertyChangeListener(this);
            this.shadow = null;
            this.repaint();
        }
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float angle) {
        this.angle = angle;
        this.computeShadowPosition();
        this.repaint();
    }

    public int getDistance() {
        return this.distance;
    }

    public void setDistance(int distance) {
        this.distance = distance;
        this.computeShadowPosition();
        this.repaint();
    }

    private void computeShadowPosition() {
        double angleRadians = Math.toRadians(this.angle);
        this.distance_x = (int)(Math.cos(angleRadians) * (double)this.distance);
        this.distance_y = (int)(Math.sin(angleRadians) * (double)this.distance);
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.shadow = null;
    }

    @Override
    public void paint(Graphics g) {
        if (this.shadow == null) {
            BufferedImage buffer = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            Graphics2D g2 = buffer.createGraphics();
            super.paint(g2);
            this.shadow = this.factory.createShadow(buffer);
            g2.dispose();
            g.drawImage(this.shadow, this.distance_x, this.distance_y, null);
            g.drawImage(buffer, 0, 0, null);
        } else if (this.isVisible()) {
            g.drawImage(this.shadow, this.distance_x, this.distance_y, null);
            super.paint(g);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.shadow = null;
        this.repaint();
    }
}

