/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.toolkit;

import com.lightcrafts.ui.toolkit.ShadowFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import sun.java2d.SunGraphics2D;
import sun.print.PeekGraphics;
import sun.print.ProxyGraphics2D;

public class LCSliderUI
extends BasicSliderUI {
    private static final BufferedImage triangleThumb;
    private static final Color lightThumbColor;
    private static final Color darkThumbColor;
    private static final Color shadowThumbColor;
    private static final int[] TRACK_COLORS;
    private static final Stroke TRACK_STROKE;
    private static final Dimension MINIMUM_HORIZONTAL_SIZE;
    private static final Dimension MINIMUM_VERTICAL_SIZE;
    private static final Dimension PREFERRED_HORIZONTAL_SIZE;
    private static final Dimension PREFERRED_VERTICAL_SIZE;
    private boolean m_isDragging = false;

    public LCSliderUI(JSlider jslider) {
        super(jslider);
    }

    public static ComponentUI createUI(JComponent comp) {
        return new LCSliderUI((JSlider)comp);
    }

    @Override
    public Dimension getMinimumHorizontalSize() {
        return MINIMUM_HORIZONTAL_SIZE;
    }

    @Override
    public Dimension getMinimumVerticalSize() {
        return MINIMUM_VERTICAL_SIZE;
    }

    @Override
    public Dimension getPreferredHorizontalSize() {
        return PREFERRED_HORIZONTAL_SIZE;
    }

    @Override
    public Dimension getPreferredVerticalSize() {
        return PREFERRED_VERTICAL_SIZE;
    }

    @Override
    public void installUI(JComponent comp) {
        boolean flag = comp.isOpaque();
        super.installUI(comp);
        this.slider.setOpaque(flag);
        this.updateFont();
    }

    @Override
    public void paint(Graphics g, JComponent unused) {
        this.recalculateIfInsetsChanged();
        Rectangle clipRect = g.getClipBounds();
        if (this.slider.getPaintTrack()) {
            if (!clipRect.intersects(this.trackRect)) {
                this.calculateGeometry();
            }
            if (clipRect.intersects(this.trackRect) || clipRect.intersects(this.thumbRect)) {
                this.paintTrack(g);
            }
        }
        if (this.slider.getPaintTicks() && clipRect.intersects(this.tickRect)) {
            this.paintTicks(g);
        }
        if (this.slider.getPaintLabels() && clipRect.intersects(this.labelRect)) {
            this.paintLabels(g);
        }
        if (clipRect.intersects(this.thumbRect)) {
            this.paintThumb(g);
        }
    }

    @Override
    public void paintFocus(Graphics g) {
    }

    @Override
    public void paintLabels(Graphics g) {
        Color color = this.slider.isEnabled() ? Color.black : Color.gray;
        Dictionary labelTable = this.slider.getLabelTable();
        if (labelTable == null) {
            return;
        }
        Enumeration keys = labelTable.keys();
        int min = this.slider.getMinimum();
        int max = this.slider.getMaximum();
        block4: while (keys.hasMoreElements()) {
            int integer = (Integer)keys.nextElement();
            if (integer < min || integer > max) continue;
            Component comp = (Component)labelTable.get(integer);
            comp.setForeground(color);
            switch (this.slider.getOrientation()) {
                case 0: {
                    g.translate(0, this.labelRect.y);
                    this.paintHorizontalLabel(g, integer, comp);
                    g.translate(0, -this.labelRect.y);
                    continue block4;
                }
                case 1: {
                    int dx = Utils.isLeftToRight(this.slider) ? 0 : this.labelRect.width - comp.getPreferredSize().width;
                    g.translate(this.labelRect.x + dx, 0);
                    this.paintVerticalLabel(g, integer, comp);
                    g.translate(-this.labelRect.x - dx, 0);
                    continue block4;
                }
            }
            throw new IllegalStateException("bad orientation");
        }
    }

    @Override
    public void paintTicks(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Object hint = Utils.beginFont(g2d);
        this.superPaintTicks(g);
        Utils.endFont(g2d, hint);
    }

    @Override
    public void paintTrack(Graphics g) {
        boolean isEnabled = this.slider.isEnabled();
        boolean isHorizontal = this.slider.getOrientation() == 0;
        SunGraphics2D g2d = Utils.getGraphics2D(g, this.trackRect.x, this.trackRect.y, this.trackRect.width, this.trackRect.height);
        if (g2d == null) {
            return;
        }
        Color oldColor = g2d.getColor();
        Stroke oldStroke = g2d.getStroke();
        g2d.setStroke(TRACK_STROKE);
        for (int i = 0; i < 3; ++i) {
            int lOff;
            if (isEnabled) {
                g2d.setColor(new Color(TRACK_COLORS[i], TRACK_COLORS[i], TRACK_COLORS[i]));
            } else {
                g2d.setColor(Color.lightGray);
            }
            int n = lOff = i == 1 ? 0 : -1;
            if (isHorizontal) {
                g2d.drawLine((int)this.trackRect.getMinX() - lOff, (int)this.trackRect.getCenterY() + i - 1, (int)this.trackRect.getMaxX() + lOff, (int)this.trackRect.getCenterY() + i - 1);
                continue;
            }
            g2d.drawLine((int)this.trackRect.getCenterX() + i - 1, (int)this.trackRect.getMinY() - lOff, (int)this.trackRect.getCenterX() + i - 1, (int)this.trackRect.getMaxY() + lOff);
        }
        g2d.setStroke(oldStroke);
        g2d.setColor(oldColor);
    }

    @Override
    public void paintThumb(Graphics g) {
        SunGraphics2D g2d = Utils.getGraphics2D(g, this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height);
        if (g2d != null) {
            g2d.drawImage(triangleThumb, null, this.thumbRect.x - 1, this.thumbRect.y);
        }
    }

    @Override
    protected void calculateContentRect() {
        super.calculateContentRect();
    }

    @Override
    protected void calculateThumbLocation() {
        super.calculateThumbLocation();
        switch (this.slider.getOrientation()) {
            case 0: {
                this.thumbRect.y = this.trackRect.y + 3;
                break;
            }
            case 1: {
                this.thumbRect.x = this.trackRect.x + 2;
                break;
            }
            default: {
                throw new IllegalStateException("bad orientation");
            }
        }
    }

    @Override
    protected void calculateThumbSize() {
        Dimension size = this.getThumbSize();
        this.thumbRect.setSize(size.width + 4, size.height + 4);
    }

    @Override
    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.height = this.slider.getPaintTicks() ? this.getTickLength() : 0;
            this.tickRect.x = this.trackRect.x + this.trackBuffer;
            this.tickRect.y = this.trackRect.y + this.trackRect.height - this.tickRect.height / 2;
            this.tickRect.width = this.trackRect.width - this.trackBuffer * 2;
        } else {
            this.tickRect.width = this.slider.getPaintTicks() ? this.getTickLength() : 0;
            this.tickRect.x = this.trackRect.x + this.trackRect.width - this.tickRect.width / 2;
            this.tickRect.y = this.trackRect.y + this.trackBuffer;
            this.tickRect.height = this.trackRect.height - this.trackBuffer * 2;
        }
    }

    @Override
    protected void calculateTrackRect() {
        switch (this.slider.getOrientation()) {
            case 0: {
                int height = this.thumbRect.height;
                if (this.slider.getPaintTicks()) {
                    height += this.getTickLength();
                }
                if (this.slider.getPaintLabels()) {
                    height += this.getHeightOfTallestLabel();
                }
                this.trackRect.x = this.contentRect.x + this.trackBuffer;
                this.trackRect.y = this.contentRect.y + (this.contentRect.height - height - 1) / 2;
                this.trackRect.width = this.contentRect.width - this.trackBuffer * 2;
                this.trackRect.height = this.thumbRect.height;
                break;
            }
            case 1: {
                int width = this.thumbRect.width;
                if (Utils.isLeftToRight(this.slider)) {
                    if (this.slider.getPaintTicks()) {
                        width += this.getTickLength();
                    }
                    if (this.slider.getPaintLabels()) {
                        width += this.getWidthOfWidestLabel();
                    }
                } else {
                    if (this.slider.getPaintTicks()) {
                        width -= this.getTickLength();
                    }
                    if (this.slider.getPaintLabels()) {
                        width -= this.getWidthOfWidestLabel();
                    }
                }
                this.trackRect.x = this.contentRect.x + (this.contentRect.width - width - 1) / 2;
                this.trackRect.y = this.contentRect.y + this.trackBuffer;
                this.trackRect.width = this.thumbRect.width;
                this.trackRect.height = this.contentRect.height - this.trackBuffer * 2;
                break;
            }
            default: {
                throw new IllegalStateException("bad orientation");
            }
        }
    }

    @Override
    protected ChangeListener createChangeListener(JSlider unused) {
        return new MyChangeListener();
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener(JSlider unused) {
        return new MyPropertyChangeHandler();
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider unused) {
        return new MyTrackListener();
    }

    @Override
    protected Dimension getThumbSize() {
        return new Dimension(13, 14);
    }

    protected boolean shouldUseArrowThumb() {
        return this.slider.getPaintTicks() || this.slider.getPaintLabels();
    }

    private void superPaintTicks(Graphics g) {
        if (this.slider.isEnabled()) {
            g.setColor(Color.gray);
        } else {
            g.setColor(Color.lightGray);
        }
        switch (this.slider.getOrientation()) {
            case 0: {
                int x;
                int i;
                g.translate(0, this.tickRect.y);
                if (this.slider.getMinorTickSpacing() > 0) {
                    for (i = this.slider.getMinimum(); i <= this.slider.getMaximum(); i += this.slider.getMinorTickSpacing()) {
                        x = this.xPositionForValue(i);
                        this.paintMinorTickForHorizSlider(g, this.tickRect, x);
                    }
                }
                if (this.slider.getMajorTickSpacing() > 0) {
                    for (i = this.slider.getMinimum(); i <= this.slider.getMaximum(); i += this.slider.getMajorTickSpacing()) {
                        x = this.xPositionForValue(i);
                        this.paintMajorTickForHorizSlider(g, this.tickRect, x);
                    }
                }
                g.translate(0, -this.tickRect.y);
                break;
            }
            case 1: {
                g.translate(this.tickRect.x, 0);
                if (this.slider.getMinorTickSpacing() > 0) {
                    int dx = 0;
                    if (!Utils.isLeftToRight(this.slider)) {
                        dx = this.tickRect.width - this.tickRect.width / 2;
                        g.translate(dx, 0);
                    }
                    for (int i = this.slider.getMinimum(); i <= this.slider.getMaximum(); i += this.slider.getMinorTickSpacing()) {
                        int y = this.yPositionForValue(i);
                        this.paintMinorTickForVertSlider(g, this.tickRect, y);
                    }
                    if (!Utils.isLeftToRight(this.slider)) {
                        g.translate(-dx, 0);
                    }
                }
                if (this.slider.getMajorTickSpacing() > 0) {
                    if (!Utils.isLeftToRight(this.slider)) {
                        g.translate(2, 0);
                    }
                    for (int i = this.slider.getMinimum(); i <= this.slider.getMaximum(); i += this.slider.getMajorTickSpacing()) {
                        int y = this.yPositionForValue(i);
                        this.paintMajorTickForVertSlider(g, this.tickRect, y);
                    }
                    if (!Utils.isLeftToRight(this.slider)) {
                        g.translate(-2, 0);
                    }
                }
                g.translate(-this.tickRect.x, 0);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void updateFont() {
        Font font = this.slider.getFont();
        if (font == null) {
            return;
        }
        this.calculateGeometry();
        this.slider.repaint();
    }

    static {
        lightThumbColor = new Color(185, 185, 185);
        darkThumbColor = new Color(110, 110, 110);
        shadowThumbColor = new Color(25, 25, 25);
        int width = 14;
        int height = 9;
        Polygon triangle = new Polygon(new int[]{0, 7, 14}, new int[]{0, 9, 0}, 3);
        BufferedImage buf = new BufferedImage(14, 11, 2);
        Graphics2D g2d = (Graphics2D)buf.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setPaint(new GradientPaint(0.0f, 0.0f, lightThumbColor, 7.0f, 0.0f, darkThumbColor));
        g2d.fill(triangle);
        g2d.dispose();
        ShadowFactory sf = new ShadowFactory(4, 0.6f, shadowThumbColor);
        sf.setRenderingHint("blur_quality", "high");
        triangleThumb = sf.createShadow(buf);
        g2d = (Graphics2D)triangleThumb.getGraphics();
        g2d.drawRenderedImage(buf, AffineTransform.getTranslateInstance(3.0, 2.0));
        g2d.dispose();
        TRACK_COLORS = new int[]{45, 90, 120};
        TRACK_STROKE = new BasicStroke(1.0f);
        MINIMUM_HORIZONTAL_SIZE = new Dimension(36, 15);
        MINIMUM_VERTICAL_SIZE = new Dimension(15, 36);
        PREFERRED_HORIZONTAL_SIZE = new Dimension(190, 15);
        PREFERRED_VERTICAL_SIZE = new Dimension(15, 190);
    }

    private class MyTrackListener
    extends BasicSliderUI.TrackListener {
        private MyTrackListener() {
            super(LCSliderUI.this);
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            if (!LCSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = event.getX();
            this.currentMouseY = event.getY();
            if (!LCSliderUI.this.m_isDragging) {
                return;
            }
            LCSliderUI.this.slider.setValueIsAdjusting(true);
            switch (LCSliderUI.this.slider.getOrientation()) {
                case 0: {
                    int halfWidth = ((LCSliderUI)LCSliderUI.this).thumbRect.width / 2;
                    int xo = event.getX() - this.offset;
                    int x1 = ((LCSliderUI)LCSliderUI.this).trackRect.x;
                    int x2 = ((LCSliderUI)LCSliderUI.this).trackRect.x + (((LCSliderUI)LCSliderUI.this).trackRect.width - 1);
                    int xv = LCSliderUI.this.xPositionForValue(LCSliderUI.this.slider.getMaximum() - LCSliderUI.this.slider.getExtent());
                    if (LCSliderUI.this.drawInverted()) {
                        x1 = xv;
                    } else {
                        x2 = xv;
                    }
                    xo = Math.max(xo, x1 - halfWidth);
                    xo = Math.min(xo, x2 - halfWidth);
                    LCSliderUI.this.setThumbLocation(xo, ((LCSliderUI)LCSliderUI.this).thumbRect.y);
                    LCSliderUI.this.slider.setValue(LCSliderUI.this.valueForXPosition(xo + halfWidth));
                    break;
                }
                case 1: {
                    int halfHeight = ((LCSliderUI)LCSliderUI.this).thumbRect.height / 2;
                    int yo = event.getY() - this.offset;
                    int y1 = ((LCSliderUI)LCSliderUI.this).trackRect.y;
                    int y2 = ((LCSliderUI)LCSliderUI.this).trackRect.y + (((LCSliderUI)LCSliderUI.this).trackRect.height - 1);
                    int yv = LCSliderUI.this.yPositionForValue(LCSliderUI.this.slider.getMaximum() - LCSliderUI.this.slider.getExtent());
                    if (LCSliderUI.this.drawInverted()) {
                        y2 = yv;
                    } else {
                        y1 = yv;
                    }
                    yo = Math.max(yo, y1 - halfHeight);
                    yo = Math.min(yo, y2 - halfHeight);
                    LCSliderUI.this.setThumbLocation(((LCSliderUI)LCSliderUI.this).thumbRect.x, yo);
                    LCSliderUI.this.slider.setValue(LCSliderUI.this.valueForYPosition(yo + halfHeight));
                    break;
                }
                default: {
                    throw new IllegalStateException("bad orientation");
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent unused) {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            byte direction;
            if (!LCSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = event.getX();
            this.currentMouseY = event.getY();
            if (LCSliderUI.this.slider.isRequestFocusEnabled()) {
                LCSliderUI.this.slider.requestFocus();
            }
            if (LCSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                switch (LCSliderUI.this.slider.getOrientation()) {
                    case 0: {
                        this.offset = this.currentMouseX - ((LCSliderUI)LCSliderUI.this).thumbRect.x;
                        break;
                    }
                    case 1: {
                        this.offset = this.currentMouseY - ((LCSliderUI)LCSliderUI.this).thumbRect.y;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("bad orientation");
                    }
                }
                LCSliderUI.this.m_isDragging = true;
                return;
            }
            LCSliderUI.this.m_isDragging = false;
            LCSliderUI.this.slider.setValueIsAdjusting(true);
            Dimension sliderSize = LCSliderUI.this.slider.getSize();
            switch (LCSliderUI.this.slider.getOrientation()) {
                case 0: {
                    if (LCSliderUI.this.thumbRect.isEmpty()) {
                        int halfWidth = sliderSize.width / 2;
                        if (LCSliderUI.this.drawInverted()) {
                            direction = (byte)(this.currentMouseX >= halfWidth ? -1 : 1);
                            break;
                        }
                        direction = (byte)(this.currentMouseX >= halfWidth ? 1 : -1);
                        break;
                    }
                    int l = ((LCSliderUI)LCSliderUI.this).thumbRect.x;
                    if (LCSliderUI.this.drawInverted()) {
                        direction = (byte)(this.currentMouseX >= l ? -1 : 1);
                        break;
                    }
                    direction = (byte)(this.currentMouseX >= l ? 1 : -1);
                    break;
                }
                case 1: {
                    if (LCSliderUI.this.thumbRect.isEmpty()) {
                        int halfHeight = sliderSize.height / 2;
                        if (LCSliderUI.this.drawInverted()) {
                            direction = (byte)(this.currentMouseY >= halfHeight ? 1 : -1);
                            break;
                        }
                        direction = (byte)(this.currentMouseY >= halfHeight ? -1 : 1);
                        break;
                    }
                    int j = ((LCSliderUI)LCSliderUI.this).thumbRect.y;
                    if (!LCSliderUI.this.drawInverted()) {
                        direction = (byte)(this.currentMouseY >= j ? -1 : 1);
                        break;
                    }
                    direction = (byte)(this.currentMouseY >= j ? 1 : -1);
                    break;
                }
                default: {
                    throw new IllegalStateException("bad orientation");
                }
            }
            LCSliderUI.this.scrollDueToClickInTrack(direction);
            if (!LCSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY) && this.shouldScroll(direction)) {
                LCSliderUI.this.scrollTimer.stop();
                LCSliderUI.this.scrollListener.setDirection(direction);
                LCSliderUI.this.scrollTimer.start();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseevent) {
            if (!LCSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.offset = 0;
            LCSliderUI.this.scrollTimer.stop();
            if (LCSliderUI.this.slider.getSnapToTicks()) {
                LCSliderUI.this.m_isDragging = false;
                LCSliderUI.this.slider.setValueIsAdjusting(false);
            } else {
                LCSliderUI.this.slider.setValueIsAdjusting(false);
                LCSliderUI.this.m_isDragging = false;
            }
            LCSliderUI.this.slider.repaint();
        }

        @Override
        public boolean shouldScroll(int direction) {
            if (LCSliderUI.this.slider.getOrientation() == 1 ? ((LCSliderUI.this.drawInverted() ? direction < 0 : direction > 0) ? ((LCSliderUI)LCSliderUI.this).thumbRect.y + ((LCSliderUI)LCSliderUI.this).thumbRect.height <= this.currentMouseY : ((LCSliderUI)LCSliderUI.this).thumbRect.y >= this.currentMouseY) : ((LCSliderUI.this.drawInverted() ? direction < 0 : direction > 0) ? ((LCSliderUI)LCSliderUI.this).thumbRect.x + ((LCSliderUI)LCSliderUI.this).thumbRect.width >= this.currentMouseX : ((LCSliderUI)LCSliderUI.this).thumbRect.x <= this.currentMouseX)) {
                return false;
            }
            if (direction > 0 && LCSliderUI.this.slider.getValue() + LCSliderUI.this.slider.getExtent() >= LCSliderUI.this.slider.getMaximum()) {
                return false;
            }
            return direction >= 0 || LCSliderUI.this.slider.getValue() > LCSliderUI.this.slider.getMinimum();
        }
    }

    private class MyPropertyChangeHandler
    extends BasicSliderUI.PropertyChangeHandler {
        private MyPropertyChangeHandler() {
            super(LCSliderUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String propName = event.getPropertyName();
            if (propName.equals("font")) {
                LCSliderUI.this.updateFont();
            } else if (propName.equals("Frame.active")) {
                LCSliderUI.this.slider.repaint();
            } else {
                super.propertyChange(event);
            }
        }
    }

    private class MyChangeListener
    implements ChangeListener {
        private MyChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent unused) {
            if (!LCSliderUI.this.m_isDragging) {
                LCSliderUI.this.calculateThumbLocation();
                LCSliderUI.this.slider.repaint();
            }
        }
    }

    private static class Utils {
        private Utils() {
        }

        static Object beginFont(Graphics2D g2d) {
            Object hint = g2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            return hint;
        }

        static void endFont(Graphics2D g2d, Object hint) {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, hint);
        }

        static SunGraphics2D getGraphics2D(Graphics g, int x, int y, int w, int h) {
            ProxyGraphics2D pg2d;
            Graphics2D g2d;
            if (g instanceof SunGraphics2D) {
                return (SunGraphics2D)g;
            }
            if (g instanceof PeekGraphics) {
                g.fillRect(x, y, w, h);
            } else if (g instanceof ProxyGraphics2D && (g2d = (pg2d = (ProxyGraphics2D)g).getDelegate()) instanceof SunGraphics2D) {
                return (SunGraphics2D)g2d;
            }
            return null;
        }

        static boolean isLeftToRight(Component component) {
            return component.getComponentOrientation().isLeftToRight();
        }
    }
}

