/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.toolkit;

import com.lightcrafts.ui.toolkit.CoolButton;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class MenuButton
extends CoolButton
implements MouseListener,
PopupMenuListener {
    private JPopupMenu menu;

    public MenuButton() {
        this.addMouseListener(this);
    }

    public MenuButton(Icon icon) {
        this.setIcon(icon);
        this.addMouseListener(this);
        this.menu = new JPopupMenu();
        this.menu.addPopupMenuListener(this);
    }

    public void add(JMenuItem item) {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            this.menu.addPopupMenuListener(this);
            this.setEnabled(true);
        }
        this.menu.add(item);
    }

    public void add(Action action) {
        JMenuItem item = new JMenuItem(action);
        this.add(item);
    }

    public void clear() {
        if (this.menu != null) {
            this.menu.removeAll();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this.isEnabled() && this.menu != null && !this.menu.isVisible()) {
            this.setSelected(true);
            Dimension size = this.getSize();
            this.menu.show(this, 0, size.height);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent event) {
        this.setSelected(false);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    public static void main(String[] args) {
        ImageIcon normal = new ImageIcon(args[0]);
        final MenuButton button = new MenuButton();
        button.setIcon(normal);
        JMenuItem item1 = new JMenuItem("Item 1");
        item1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.out.println("item 1");
            }
        });
        button.add(item1);
        JMenuItem item2 = new JMenuItem("Item 2");
        item2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.out.println("item 2");
            }
        });
        button.add(item2);
        JButton enable = new JButton("Enable");
        enable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                button.setEnabled(true);
            }
        });
        JButton disable = new JButton("Disable");
        disable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                button.setEnabled(false);
            }
        });
        JPanel panel = new JPanel(new FlowLayout());
        panel.add(button);
        panel.add(enable);
        panel.add(disable);
        JFrame frame = new JFrame("MenuButton Test");
        frame.setContentPane(panel);
        frame.setBounds(100, 100, 200, 200);
        frame.setVisible(true);
    }
}

