/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.toolkit;

import com.lightcrafts.platform.Platform;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class UICompliance {
    public static int showOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, final Object[] options, Object initialValue, int destructive) throws HeadlessException {
        final JOptionPane pane = new JOptionPane(message, messageType, optionType, icon, options, initialValue);
        pane.setInitialValue(initialValue);
        pane.setComponentOrientation((parentComponent == null ? JOptionPane.getRootFrame() : parentComponent).getComponentOrientation());
        JDialog dialog = pane.createDialog(parentComponent, title);
        for (int i = 2; i < options.length; ++i) {
            final int o = i;
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    pane.setValue(options[o]);
                }
            };
            KeyStroke stroke = KeyStroke.getKeyStroke((int)((String)options[i]).charAt(0), Platform.getType() == Platform.MacOSX ? 4 : 2);
            dialog.getRootPane().getInputMap(2).put(stroke, action);
            dialog.getRootPane().getActionMap().put(action, action);
        }
        pane.selectInitialValue();
        dialog.show();
        dialog.dispose();
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        if (options == null) {
            if (selectedValue instanceof Integer) {
                return (Integer)selectedValue;
            }
            return -1;
        }
        int maxCounter = options.length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (!options[counter].equals(selectedValue)) continue;
            return counter;
        }
        return -1;
    }
}

