/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.toolkit;

import com.lightcrafts.platform.Platform;
import com.lightcrafts.utils.ColorProfileInfo;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.UIManager;

public class WidePopupComboBox
extends JComboBox {
    private int maxItemLenght = 0;

    public WidePopupComboBox() {
        super(new DefaultComboBoxModel(){

            @Override
            public void setSelectedItem(Object o) {
                if (o != null) {
                    super.setSelectedItem(o);
                }
            }
        });
        this.setRenderer(new ComboBoxRenderer());
    }

    public void addItem(Object anObject) {
        int lenght;
        super.addItem(anObject);
        if (anObject != null && (lenght = anObject.toString().length()) > this.maxItemLenght) {
            this.maxItemLenght = lenght;
            this.putClientProperty("substancelaf.comboPopupPrototype", anObject);
        }
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(Platform.getPlatform().getLookAndFeel());
        WidePopupComboBox combo = new WidePopupComboBox();
        Collection<ColorProfileInfo> PrinterProfiles = Platform.getPlatform().getPrinterProfiles();
        List<ColorProfileInfo> profiles = ColorProfileInfo.arrangeForMenu(PrinterProfiles);
        for (ColorProfileInfo profile : profiles) {
            combo.addItem(profile);
        }
        JFrame frame = new JFrame("Test");
        frame.getContentPane().setLayout(new FlowLayout());
        frame.getContentPane().add(combo);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    static class ComboBoxRenderer
    extends DefaultListCellRenderer {
        static final Component Separator = new JSeparator();

        ComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                return Separator;
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }

        static {
            Separator.setSize(Separator.getPreferredSize());
        }
    }
}

