/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.toolkit.journal;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;

class TapEventQueue
extends EventQueue {
    private AWTEventListener listener;
    private boolean isPushed;

    TapEventQueue(AWTEventListener listener) {
        this.listener = listener;
    }

    void tapStart() {
        if (!this.isPushed) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            EventQueue queue = toolkit.getSystemEventQueue();
            queue.push(this);
            this.isPushed = true;
        }
    }

    boolean isTapped() {
        return this.isPushed;
    }

    void tapEnd() {
        if (this.isPushed) {
            this.pop();
            this.isPushed = false;
        }
    }

    @Override
    protected void dispatchEvent(AWTEvent event) {
        if (event instanceof InputEvent) {
            this.listener.eventDispatched(event);
        }
        super.dispatchEvent(event);
    }
}

