/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.toolkit.journal;

import com.lightcrafts.ui.toolkit.journal.TapEventQueue;
import java.awt.AWTEvent;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;

class TapQueueControl
implements AWTEventListener {
    static AWTEvent TapStartEvent = new AWTEvent(TapQueueControl.class, 0){};
    static AWTEvent TapEndEvent = new AWTEvent(TapQueueControl.class, 1){};
    private TapEventQueue queue;
    private AWTEventListener listener;
    private int controlKeyCode;
    private boolean isControlOn;

    TapQueueControl(AWTEventListener listener, int keyCode) {
        this.listener = listener;
        this.queue = new TapEventQueue(this);
        this.controlKeyCode = keyCode;
        this.queue.tapStart();
    }

    boolean isTapped() {
        return this.queue.isTapped();
    }

    void dispose() {
        this.queue.tapEnd();
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        this.updateControlState(event);
        if (this.isControlOn && !this.isControlEvent(event)) {
            this.listener.eventDispatched(event);
        }
    }

    private void updateControlState(AWTEvent event) {
        KeyEvent key;
        int code;
        if (event instanceof KeyEvent && (code = (key = (KeyEvent)event).getKeyCode()) == this.controlKeyCode && key.getID() == 401) {
            boolean bl = this.isControlOn = !this.isControlOn;
            if (this.isControlOn) {
                this.listener.eventDispatched(TapStartEvent);
            } else {
                this.listener.eventDispatched(TapEndEvent);
            }
            System.out.println("*** TapQueueControl " + (this.isControlOn ? "ON" : "OFF") + " ***");
        }
    }

    private boolean isControlEvent(AWTEvent event) {
        return event instanceof KeyEvent && ((KeyEvent)event).getKeyCode() == this.controlKeyCode;
    }
}

