/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils;

import com.lightcrafts.utils.ColorScience;

public class ColorMatrix2 {
    public static final float RLUM = ColorScience.Wr;
    public static final float GLUM = ColorScience.Wg;
    public static final float BLUM = ColorScience.Wb;

    static void matrixmult(float[][] a, float[][] b, float[][] c) {
        int x;
        int y;
        float[][] temp = new float[4][4];
        for (y = 0; y < 4; ++y) {
            for (x = 0; x < 4; ++x) {
                temp[y][x] = b[y][0] * a[0][x] + b[y][1] * a[1][x] + b[y][2] * a[2][x] + b[y][3] * a[3][x];
            }
        }
        for (y = 0; y < 4; ++y) {
            for (x = 0; x < 4; ++x) {
                c[y][x] = temp[y][x];
            }
        }
    }

    public static void xformpnt(float[][] matrix, float[] in, float[] out) {
        out[0] = in[0] * matrix[0][0] + in[1] * matrix[1][0] + in[2] * matrix[2][0] + matrix[3][0];
        out[1] = in[0] * matrix[0][1] + in[1] * matrix[1][1] + in[2] * matrix[2][1] + matrix[3][1];
        out[2] = in[0] * matrix[0][2] + in[1] * matrix[1][2] + in[2] * matrix[2][2] + matrix[3][2];
    }

    public static void cscalemat(float[][] mat, float rscale, float gscale, float bscale) {
        float[][] mmat = new float[4][4];
        mmat[0][0] = rscale;
        mmat[0][1] = 0.0f;
        mmat[0][2] = 0.0f;
        mmat[0][3] = 0.0f;
        mmat[1][0] = 0.0f;
        mmat[1][1] = gscale;
        mmat[1][2] = 0.0f;
        mmat[1][3] = 0.0f;
        mmat[2][0] = 0.0f;
        mmat[2][1] = 0.0f;
        mmat[2][2] = bscale;
        mmat[2][3] = 0.0f;
        mmat[3][0] = 0.0f;
        mmat[3][1] = 0.0f;
        mmat[3][2] = 0.0f;
        mmat[3][3] = 1.0f;
        ColorMatrix2.matrixmult(mmat, mat, mat);
    }

    public static void lummat(float[][] mat) {
        float[][] mmat = new float[4][4];
        float rwgt = RLUM;
        float gwgt = GLUM;
        float bwgt = BLUM;
        mmat[0][0] = rwgt;
        mmat[0][1] = rwgt;
        mmat[0][2] = rwgt;
        mmat[0][3] = 0.0f;
        mmat[1][0] = gwgt;
        mmat[1][1] = gwgt;
        mmat[1][2] = gwgt;
        mmat[1][3] = 0.0f;
        mmat[2][0] = bwgt;
        mmat[2][1] = bwgt;
        mmat[2][2] = bwgt;
        mmat[2][3] = 0.0f;
        mmat[3][0] = 0.0f;
        mmat[3][1] = 0.0f;
        mmat[3][2] = 0.0f;
        mmat[3][3] = 1.0f;
        ColorMatrix2.matrixmult(mmat, mat, mat);
    }

    public static void saturatemat(float[][] mat, float sat) {
        float[][] mmat = new float[4][4];
        float rwgt = RLUM;
        float gwgt = GLUM;
        float bwgt = BLUM;
        float a = (1.0f - sat) * rwgt + sat;
        float b = (1.0f - sat) * rwgt;
        float c = (1.0f - sat) * rwgt;
        float d = (1.0f - sat) * gwgt;
        float e = (1.0f - sat) * gwgt + sat;
        float f = (1.0f - sat) * gwgt;
        float g = (1.0f - sat) * bwgt;
        float h = (1.0f - sat) * bwgt;
        float i = (1.0f - sat) * bwgt + sat;
        mmat[0][0] = a;
        mmat[0][1] = b;
        mmat[0][2] = c;
        mmat[0][3] = 0.0f;
        mmat[1][0] = d;
        mmat[1][1] = e;
        mmat[1][2] = f;
        mmat[1][3] = 0.0f;
        mmat[2][0] = g;
        mmat[2][1] = h;
        mmat[2][2] = i;
        mmat[2][3] = 0.0f;
        mmat[3][0] = 0.0f;
        mmat[3][1] = 0.0f;
        mmat[3][2] = 0.0f;
        mmat[3][3] = 1.0f;
        ColorMatrix2.matrixmult(mmat, mat, mat);
    }

    public static void offsetmat(float[][] mat, float roffset, float goffset, float boffset) {
        float[][] mmat = new float[4][4];
        mmat[0][0] = 1.0f;
        mmat[0][1] = 0.0f;
        mmat[0][2] = 0.0f;
        mmat[0][3] = 0.0f;
        mmat[1][0] = 0.0f;
        mmat[1][1] = 1.0f;
        mmat[1][2] = 0.0f;
        mmat[1][3] = 0.0f;
        mmat[2][0] = 0.0f;
        mmat[2][1] = 0.0f;
        mmat[2][2] = 1.0f;
        mmat[2][3] = 0.0f;
        mmat[3][0] = roffset;
        mmat[3][1] = goffset;
        mmat[3][2] = boffset;
        mmat[3][3] = 1.0f;
        ColorMatrix2.matrixmult(mmat, mat, mat);
    }

    public static void xrotatemat(float[][] mat, float rs, float rc) {
        float[][] mmat = new float[4][4];
        mmat[0][0] = 1.0f;
        mmat[0][1] = 0.0f;
        mmat[0][2] = 0.0f;
        mmat[0][3] = 0.0f;
        mmat[1][0] = 0.0f;
        mmat[1][1] = rc;
        mmat[1][2] = rs;
        mmat[1][3] = 0.0f;
        mmat[2][0] = 0.0f;
        mmat[2][1] = -rs;
        mmat[2][2] = rc;
        mmat[2][3] = 0.0f;
        mmat[3][0] = 0.0f;
        mmat[3][1] = 0.0f;
        mmat[3][2] = 0.0f;
        mmat[3][3] = 1.0f;
        ColorMatrix2.matrixmult(mmat, mat, mat);
    }

    public static void yrotatemat(float[][] mat, float rs, float rc) {
        float[][] mmat = new float[4][4];
        mmat[0][0] = rc;
        mmat[0][1] = 0.0f;
        mmat[0][2] = -rs;
        mmat[0][3] = 0.0f;
        mmat[1][0] = 0.0f;
        mmat[1][1] = 1.0f;
        mmat[1][2] = 0.0f;
        mmat[1][3] = 0.0f;
        mmat[2][0] = rs;
        mmat[2][1] = 0.0f;
        mmat[2][2] = rc;
        mmat[2][3] = 0.0f;
        mmat[3][0] = 0.0f;
        mmat[3][1] = 0.0f;
        mmat[3][2] = 0.0f;
        mmat[3][3] = 1.0f;
        ColorMatrix2.matrixmult(mmat, mat, mat);
    }

    public static void zrotatemat(float[][] mat, float rs, float rc) {
        float[][] mmat = new float[4][4];
        mmat[0][0] = rc;
        mmat[0][1] = rs;
        mmat[0][2] = 0.0f;
        mmat[0][3] = 0.0f;
        mmat[1][0] = -rs;
        mmat[1][1] = rc;
        mmat[1][2] = 0.0f;
        mmat[1][3] = 0.0f;
        mmat[2][0] = 0.0f;
        mmat[2][1] = 0.0f;
        mmat[2][2] = 1.0f;
        mmat[2][3] = 0.0f;
        mmat[3][0] = 0.0f;
        mmat[3][1] = 0.0f;
        mmat[3][2] = 0.0f;
        mmat[3][3] = 1.0f;
        ColorMatrix2.matrixmult(mmat, mat, mat);
    }

    public static void zshearmat(float[][] mat, float dx, float dy) {
        float[][] mmat = new float[4][4];
        mmat[0][0] = 1.0f;
        mmat[0][1] = 0.0f;
        mmat[0][2] = dx;
        mmat[0][3] = 0.0f;
        mmat[1][0] = 0.0f;
        mmat[1][1] = 1.0f;
        mmat[1][2] = dy;
        mmat[1][3] = 0.0f;
        mmat[2][0] = 0.0f;
        mmat[2][1] = 0.0f;
        mmat[2][2] = 1.0f;
        mmat[2][3] = 0.0f;
        mmat[3][0] = 0.0f;
        mmat[3][1] = 0.0f;
        mmat[3][2] = 0.0f;
        mmat[3][3] = 1.0f;
        ColorMatrix2.matrixmult(mmat, mat, mat);
    }

    public static void simplehuerotatemat(float[][] mat, float rot) {
        float mag = (float)Math.sqrt(2.0);
        float xrs = 1.0f / mag;
        float xrc = 1.0f / mag;
        ColorMatrix2.xrotatemat(mat, xrs, xrc);
        mag = (float)Math.sqrt(3.0);
        float yrs = -1.0f / mag;
        float yrc = (float)Math.sqrt(2.0) / mag;
        ColorMatrix2.yrotatemat(mat, yrs, yrc);
        float zrs = (float)Math.sin((double)rot * Math.PI / 180.0);
        float zrc = (float)Math.cos((double)rot * Math.PI / 180.0);
        ColorMatrix2.zrotatemat(mat, zrs, zrc);
        ColorMatrix2.yrotatemat(mat, -yrs, yrc);
        ColorMatrix2.xrotatemat(mat, -xrs, xrc);
    }

    public static void huerotatemat(float[][] mat, float rot) {
        float[][] mmat = new float[][]{{1.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 1.0f}};
        float[] l = new float[3];
        float mag = (float)Math.sqrt(2.0);
        float xrs = 1.0f / mag;
        float xrc = 1.0f / mag;
        ColorMatrix2.xrotatemat(mmat, xrs, xrc);
        mag = (float)Math.sqrt(3.0);
        float yrs = -1.0f / mag;
        float yrc = (float)Math.sqrt(2.0) / mag;
        ColorMatrix2.yrotatemat(mmat, yrs, yrc);
        ColorMatrix2.xformpnt(mmat, new float[]{RLUM, GLUM, BLUM}, l);
        float zsx = l[0] / l[2];
        float zsy = l[1] / l[2];
        ColorMatrix2.zshearmat(mmat, zsx, zsy);
        float zrs = (float)Math.sin((double)rot * Math.PI / 180.0);
        float zrc = (float)Math.cos((double)rot * Math.PI / 180.0);
        ColorMatrix2.zrotatemat(mmat, zrs, zrc);
        ColorMatrix2.zshearmat(mmat, -zsx, -zsy);
        ColorMatrix2.yrotatemat(mmat, -yrs, yrc);
        ColorMatrix2.xrotatemat(mmat, -xrs, xrc);
        ColorMatrix2.matrixmult(mmat, mat, mat);
    }
}

