/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ForkDaemon {
    public static ForkDaemon INSTANCE;
    private static final String FORKDAEMON_NAME = "LightZone-forkd";
    private static final String FORKDAEMON_PATH;
    private static final String CMDSTART = "CMDSTART";
    private static final String CMDEND = "CMDEND";
    private final Process forkerProcess = Runtime.getRuntime().exec(FORKDAEMON_PATH);
    private final OutputStream stdin = this.forkerProcess.getOutputStream();
    private final InputStream stdout = this.forkerProcess.getInputStream();
    private final InputStream stderr = new BufferedInputStream(this.forkerProcess.getErrorStream());

    public InputStream getStdErr() {
        return this.stderr;
    }

    public OutputStream getStdIn() {
        return this.stdin;
    }

    public InputStream getStdOut() {
        return this.stdout;
    }

    public synchronized void invoke(String[] args) {
        try {
            int bytesAvailable = this.stdout.available();
            if (bytesAvailable > 0) {
                this.stdout.read(new byte[bytesAvailable]);
            }
            if ((bytesAvailable = this.stderr.available()) > 0) {
                this.stderr.read(new byte[bytesAvailable]);
            }
            this.stdin.write(CMDSTART.getBytes("UTF-8"));
            this.stdin.write(10);
            for (String arg : args) {
                this.stdin.write(arg.getBytes("UTF-8"));
                this.stdin.write(10);
            }
            this.stdin.write(CMDEND.getBytes("UTF-8"));
            this.stdin.write(10);
            this.stdin.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void start() throws IOException {
        INSTANCE = new ForkDaemon();
    }

    protected void finalize() throws Throwable {
        IOException caughtException;
        block8: {
            block7: {
                caughtException = null;
                try {
                    this.stderr.close();
                }
                catch (IOException e) {
                    caughtException = e;
                }
                try {
                    this.stdout.close();
                }
                catch (IOException e) {
                    if (caughtException != null) break block7;
                    caughtException = e;
                }
            }
            try {
                this.stdin.close();
            }
            catch (IOException e) {
                if (caughtException != null) break block8;
                caughtException = e;
            }
        }
        this.forkerProcess.destroy();
        if (caughtException != null) {
            throw caughtException;
        }
        super.finalize();
    }

    private ForkDaemon() throws IOException {
    }

    public static void main(String[] args) {
        try {
            int chars;
            ForkDaemon daemon = new ForkDaemon();
            byte[] buffer = new byte[256];
            daemon.invoke(new String[]{"./dcraw"});
            while ((chars = daemon.stderr.read(buffer)) >= 0) {
                System.out.println(new String(buffer, 0, chars));
            }
            while (true) {
                if (daemon.stdout.available() <= 0) {
                    continue;
                }
                chars = daemon.stdout.read(buffer);
                if (chars >= 0) {
                    System.out.println(new String(buffer, 0, chars));
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        String dir = System.getProperty("install4j.appDir");
        if (dir == null) {
            dir = ".";
        }
        FORKDAEMON_PATH = dir + File.separatorChar + FORKDAEMON_NAME;
    }
}

