/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils;

import com.lightcrafts.platform.Platform;

public class MemoryLimits {
    public static final double DefaultMemoryFraction = 0.3;

    public static int getMinimum() {
        return 256;
    }

    public static int getMaximum() {
        int physicalMax = Platform.getPlatform().getPhysicalMemoryInMB();
        int platformMax = Platform.getType().equals((Object)Platform.Windows) ? 1536 : 2560;
        return Math.min(physicalMax, platformMax);
    }

    public static int getDefault() {
        int physicalMax = Platform.getPlatform().getPhysicalMemoryInMB();
        int limit = (int)Math.round(0.3 * (double)physicalMax);
        limit = Math.max(limit, MemoryLimits.getMinimum());
        limit = Math.min(limit, MemoryLimits.getMaximum());
        return limit;
    }
}

