/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class SoftValueHashMap
extends AbstractMap {
    private final Map m_map = new HashMap();
    private final ReferenceQueue m_refQueue = new ReferenceQueue();

    @Override
    public void clear() {
        this.processQueue();
        this.m_map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        this.processQueue();
        return this.m_map.containsKey(key);
    }

    @Override
    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(Object key) {
        Object value = null;
        Reference valueRef = (Reference)this.m_map.get(key);
        if (valueRef != null && (value = valueRef.get()) == null) {
            this.m_map.remove(key);
        }
        return value;
    }

    @Override
    public Object put(Object key, Object value) {
        this.processQueue();
        ValueReference newValueRef = new ValueReference(key, value, this.m_refQueue);
        Reference oldValueRef = this.m_map.put(key, newValueRef);
        return oldValueRef != null ? oldValueRef.get() : null;
    }

    @Override
    public Object remove(Object key) {
        this.processQueue();
        return this.m_map.remove(key);
    }

    @Override
    public int size() {
        this.processQueue();
        return this.m_map.size();
    }

    private void processQueue() {
        ValueReference valueRef;
        while ((valueRef = (ValueReference)this.m_refQueue.poll()) != null) {
            this.m_map.remove(valueRef.m_key);
        }
        return;
    }

    private static final class ValueReference
    extends SoftReference {
        private final Object m_key;

        ValueReference(Object key, Object referrent, ReferenceQueue q) {
            super(referrent, q);
            this.m_key = key;
        }
    }
}

