/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils;

import com.lightcrafts.utils.NumberUtil;
import com.lightcrafts.utils.Rational;
import java.text.DateFormat;
import java.util.Date;
import jdk1_6.java.text.Normalizer;

public final class TextUtil {
    public static final long K = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    private static final String HEX_ALPHABET = "0123456789ABCDEF";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dateFormat(DateFormat f, Date d) {
        DateFormat dateFormat = f;
        synchronized (dateFormat) {
            return f.format(d);
        }
    }

    public static String hexString(byte[] buf) {
        StringBuilder hexBuf = new StringBuilder(buf.length * 2);
        byte[] arr$ = buf;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Byte b = arr$[i$];
            hexBuf.append(HEX_ALPHABET.charAt(b >>> 4 & 0xF));
            hexBuf.append(HEX_ALPHABET.charAt((int)(b & 0xF)));
        }
        return hexBuf.toString();
    }

    public static String join(String[] strings, String sep) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0 && sep != null) {
                sb.append(sep);
            }
            sb.append(strings[i]);
        }
        return sb.toString();
    }

    public static String normalize(String s) {
        return Normalizer.normalize((CharSequence)s, (Normalizer.Form)Normalizer.Form.NFD);
    }

    public static String quantify(long size) {
        if (size < 1024L) {
            return Long.toString(size) + 'B';
        }
        if (size < 0x100000L) {
            return Long.toString(size / 1024L) + 'K';
        }
        if (size < 0x40000000L) {
            return TextUtil.tenths((double)size / 1048576.0) + "MB";
        }
        return TextUtil.tenths((double)size / 1.073741824E9) + "GB";
    }

    public static String tenths(double n) {
        return Double.toString(NumberUtil.tenths(n));
    }

    public static String tenths(Rational n) {
        return TextUtil.tenths(n.doubleValue());
    }

    public static String zeroPad(int n, int base, int width) {
        String s;
        switch (base) {
            case 10: {
                s = Integer.toString(n);
                break;
            }
            case 16: {
                s = Integer.toHexString(n).toUpperCase();
                break;
            }
            default: {
                throw new IllegalArgumentException("base must be 10 or 16");
            }
        }
        int len = s.length();
        return len < width ? "0000000".substring(7 - width + len) + s : s;
    }
}

