/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;

public final class Version {
    private static final ResourceBundle m_properties = ResourceBundle.getBundle("com.lightcrafts.utils.resources.Version");
    private static DateFormat ChangeDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    private static Pattern ChangeDatePattern = Pattern.compile(".*^Last Changed Date:\\s*([^(]+).*", 40);
    private static String SVNInfo;
    private static String Version;
    private static Pattern RevisionPattern;
    private static Pattern UrlPattern;

    public static String getApplicationName() {
        return m_properties.getString("app-name");
    }

    public static URL getApplicationURL() {
        try {
            return new URL(m_properties.getString("app-URL"));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static URL getVideoLearningCenterURL() {
        try {
            return new URL(m_properties.getString("VideoLearningCenter-URL"));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static Map<String, URL> getVideoURLs() {
        HashMap<String, URL> map = new HashMap<String, URL>();
        map.put("Introduction to Relight", com.lightcrafts.utils.Version.getVideoLearningCenterURL());
        map.put("Advanced Relight", com.lightcrafts.utils.Version.getVideoLearningCenterURL());
        map.put("Introduction to ZoneMapper", com.lightcrafts.utils.Version.getVideoLearningCenterURL());
        map.put("Advanced ZoneMapper", com.lightcrafts.utils.Version.getVideoLearningCenterURL());
        return map;
    }

    public static int getRevisionNumber() {
        if (SVNInfo == null) {
            return -1;
        }
        try {
            String text = RevisionPattern.matcher(SVNInfo).replaceAll("$1");
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static Date getChangeDate() {
        if (SVNInfo == null) {
            return null;
        }
        try {
            String text = ChangeDatePattern.matcher(SVNInfo).replaceAll("$1");
            return ChangeDateFormat.parse(text);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static URI getUri() {
        if (SVNInfo == null) {
            return null;
        }
        try {
            String text = UrlPattern.matcher(SVNInfo).replaceAll("$1");
            return new URI(text);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static String getVersionName() {
        return Version;
    }

    public static URL getHomepageURL() {
        try {
            return new URL(m_properties.getString("company-URL"));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static URL getHelpURL() {
        try {
            return new URL(m_properties.getString("help-URL"));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readResource(String name) {
        InputStream in = null;
        try {
            String line;
            URL url = Version.class.getResource("resources/" + name);
            if (url == null) {
                throw new FileNotFoundException("Revision resource");
            }
            in = url.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            StringBuilder sb = new StringBuilder();
            do {
                if ((line = reader.readLine()) == null) continue;
                sb.append(line);
                sb.append('\n');
            } while (line != null);
            String string = sb.toString();
            return string;
        }
        catch (Throwable t) {
            System.err.println("Failed to read " + name + " resource");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(com.lightcrafts.utils.Version.getApplicationName());
        System.out.println(com.lightcrafts.utils.Version.getUri());
        System.out.println(com.lightcrafts.utils.Version.getRevisionNumber());
        System.out.println(com.lightcrafts.utils.Version.getChangeDate());
    }

    static {
        RevisionPattern = Pattern.compile(".*^Revision:\\s*([0-9]+).*", 40);
        UrlPattern = Pattern.compile(".*^URL:\\s*([^\\s]+)$.*", 40);
        SVNInfo = com.lightcrafts.utils.Version.readResource("Revision");
        Version = com.lightcrafts.utils.Version.readResource("Version");
        if (Version != null) {
            Version = Version.trim();
        }
    }
}

