/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.bytebuffer;

import com.lightcrafts.utils.CloseableManager;
import com.lightcrafts.utils.bytebuffer.ByteBufferUtil;
import com.lightcrafts.utils.bytebuffer.LCByteBuffer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import sun.nio.ch.DirectBuffer;

public final class LCReopenableMappedByteBuffer
extends LCByteBuffer
implements Closeable {
    private ByteBuffer m_buf;
    private final CloseableManager m_closeableManager;
    private final File m_file;
    private final FileChannel.MapMode m_mode;
    private ByteOrder m_order;
    private final long m_position;
    private final long m_size;

    public LCReopenableMappedByteBuffer(File file) {
        this(file, FileChannel.MapMode.READ_ONLY);
    }

    public LCReopenableMappedByteBuffer(File file, FileChannel.MapMode mode) {
        this(file, 0L, file.length(), mode, null);
    }

    public LCReopenableMappedByteBuffer(File file, CloseableManager closeableManager) {
        this(file, 0L, file.length(), FileChannel.MapMode.READ_ONLY, closeableManager);
    }

    public LCReopenableMappedByteBuffer(File file, long position, long size, FileChannel.MapMode mode) {
        this(file, position, size, mode, null);
    }

    public LCReopenableMappedByteBuffer(File file, long position, long size, FileChannel.MapMode mode, CloseableManager closeableManager) {
        super((int)size);
        this.m_closeableManager = closeableManager;
        this.m_file = file;
        this.m_mode = mode;
        this.m_order = ByteOrder.BIG_ENDIAN;
        this.m_position = position;
        this.m_size = size;
    }

    @Override
    public synchronized void close() {
        if (this.m_buf instanceof DirectBuffer) {
            ((DirectBuffer)((Object)this.m_buf)).cleaner().clean();
        }
        this.m_buf = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte get(int pos) throws IOException {
        LCReopenableMappedByteBuffer lCReopenableMappedByteBuffer = this;
        synchronized (lCReopenableMappedByteBuffer) {
            return this.getBuf().get(this.initialOffset() + pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LCByteBuffer get(byte[] dest, int offset, int length) throws IOException {
        int pos = this.position();
        LCReopenableMappedByteBuffer lCReopenableMappedByteBuffer = this;
        synchronized (lCReopenableMappedByteBuffer) {
            ByteBuffer buf = this.getBuf();
            buf.position(this.initialOffset() + pos);
            buf.get(dest, offset, length);
        }
        this.position(pos + length);
        return this;
    }

    public ByteBuffer getByteBuffer() {
        return this.m_buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int pos) throws IOException {
        LCReopenableMappedByteBuffer lCReopenableMappedByteBuffer = this;
        synchronized (lCReopenableMappedByteBuffer) {
            return this.getBuf().getDouble(this.initialOffset() + pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int pos) throws IOException {
        LCReopenableMappedByteBuffer lCReopenableMappedByteBuffer = this;
        synchronized (lCReopenableMappedByteBuffer) {
            return this.getBuf().getFloat(this.initialOffset() + pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int pos) throws IOException {
        LCReopenableMappedByteBuffer lCReopenableMappedByteBuffer = this;
        synchronized (lCReopenableMappedByteBuffer) {
            return this.getBuf().getInt(this.initialOffset() + pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int pos) throws IOException {
        LCReopenableMappedByteBuffer lCReopenableMappedByteBuffer = this;
        synchronized (lCReopenableMappedByteBuffer) {
            return this.getBuf().getLong(this.initialOffset() + pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int pos) throws IOException {
        LCReopenableMappedByteBuffer lCReopenableMappedByteBuffer = this;
        synchronized (lCReopenableMappedByteBuffer) {
            return this.getBuf().getShort(this.initialOffset() + pos);
        }
    }

    @Override
    public ByteOrder order() {
        return this.m_order;
    }

    @Override
    public synchronized LCByteBuffer order(ByteOrder order) {
        this.m_order = order;
        if (this.m_buf != null) {
            this.m_buf.order(order);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LCReopenableMappedByteBuffer put(int pos, byte value) throws IOException {
        LCReopenableMappedByteBuffer lCReopenableMappedByteBuffer = this;
        synchronized (lCReopenableMappedByteBuffer) {
            this.getBuf().put(this.initialOffset() + pos, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LCReopenableMappedByteBuffer putDouble(int pos, double value) throws IOException {
        LCReopenableMappedByteBuffer lCReopenableMappedByteBuffer = this;
        synchronized (lCReopenableMappedByteBuffer) {
            this.getBuf().putDouble(this.initialOffset() + pos, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LCReopenableMappedByteBuffer putFloat(int pos, float value) throws IOException {
        LCReopenableMappedByteBuffer lCReopenableMappedByteBuffer = this;
        synchronized (lCReopenableMappedByteBuffer) {
            this.getBuf().putFloat(this.initialOffset() + pos, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LCReopenableMappedByteBuffer putInt(int pos, int value) throws IOException {
        LCReopenableMappedByteBuffer lCReopenableMappedByteBuffer = this;
        synchronized (lCReopenableMappedByteBuffer) {
            this.getBuf().putInt(this.initialOffset() + pos, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LCReopenableMappedByteBuffer putLong(int pos, long value) throws IOException {
        LCReopenableMappedByteBuffer lCReopenableMappedByteBuffer = this;
        synchronized (lCReopenableMappedByteBuffer) {
            this.getBuf().putLong(this.initialOffset() + pos, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LCReopenableMappedByteBuffer putShort(int pos, short value) throws IOException {
        LCReopenableMappedByteBuffer lCReopenableMappedByteBuffer = this;
        synchronized (lCReopenableMappedByteBuffer) {
            this.getBuf().putShort(this.initialOffset() + pos, value);
        }
        return this;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private ByteBuffer getBuf() throws IOException {
        if (this.m_buf == null) {
            if (this.m_closeableManager != null) {
                this.m_closeableManager.manage(this);
            }
            this.m_buf = ByteBufferUtil.map(this.m_file, this.m_position, this.m_size, this.m_mode);
            this.m_buf.order(this.m_order);
        }
        return this.m_buf;
    }
}

