/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.cache;

import com.lightcrafts.utils.cache.CacheBlock;
import com.lightcrafts.utils.cache.CacheObjectBroker;
import com.lightcrafts.utils.cache.CacheObjectMap;
import com.lightcrafts.utils.cache.CacheStore;
import com.lightcrafts.utils.cache.FreeBlockManager;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public final class Cache {
    private final Map<Object, CacheBlock> m_blockMap = new HashMap<Object, CacheBlock>();
    private final FreeBlockManager m_freeBlockMgr;
    private final CacheObjectBroker m_objBroker;
    private final CacheObjectMap m_objMap;
    private final CacheStore m_store;

    public Cache(CacheObjectBroker objBroker, CacheObjectMap objMap, CacheStore store, FreeBlockManager freeBlockMgr) {
        this.m_freeBlockMgr = freeBlockMgr;
        this.m_objBroker = objBroker;
        this.m_objMap = objMap;
        this.m_objMap.setCache(this);
        this.m_store = store;
    }

    public synchronized void clear() throws IOException {
        this.m_blockMap.clear();
        this.m_freeBlockMgr.clear();
        this.m_objMap.clear();
        this.m_store.clear();
    }

    public synchronized boolean contains(Object key) {
        return this.m_objMap.contains(key);
    }

    public synchronized void dispose() throws IOException {
        this.m_objMap.dispose();
        this.m_store.dispose();
    }

    public Object getOnce(Object key, Object aux) throws IOException {
        return this.m_objMap.getOnce(key, aux);
    }

    public CacheObjectBroker getCacheObjectBroker() {
        return this.m_objBroker;
    }

    public CacheObjectMap getCacheObjectMap() {
        return this.m_objMap;
    }

    public CacheStore getCacheStore() {
        return this.m_store;
    }

    public FreeBlockManager getFreeBlockManager() {
        return this.m_freeBlockMgr;
    }

    public void put(Object key, Object obj) throws IOException {
        this.m_objMap.put(key, obj);
    }

    public boolean remove(Object key) {
        return this.m_objMap.remove(key);
    }

    public synchronized Object readFromStore(Object key, Object aux) throws IOException {
        CacheBlock block = this.m_blockMap.remove(key);
        if (block == null) {
            return null;
        }
        ByteBuffer buf = this.m_store.getByteBuffer(block.getSize());
        this.m_store.readFromStore(block.getPosition(), buf);
        Object obj = this.m_objBroker.decodeFromByteBuffer(buf, aux);
        this.m_freeBlockMgr.freeBlock(block);
        return obj;
    }

    public synchronized boolean removeFromStore(Object key) {
        CacheBlock block = this.m_blockMap.remove(key);
        if (block != null) {
            this.m_freeBlockMgr.freeBlock(block);
            return true;
        }
        return false;
    }

    public synchronized boolean storeContains(Object key) {
        return this.m_blockMap.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeToStore(Object key, ByteBuffer buf) throws IOException {
        int objSize = buf.limit();
        CacheBlock block = this.m_freeBlockMgr.findBlockOfSize(objSize);
        if (block == null) {
            CacheStore cacheStore = this.m_store;
            synchronized (cacheStore) {
                block = new CacheBlock(this.m_store.getSize(), objSize);
                this.m_store.writeToStore(block.getPosition(), buf);
            }
        } else {
            this.m_store.writeToStore(block.getPosition(), buf);
        }
        this.m_blockMap.put(key, block);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }
}

