/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.cache;

import com.lightcrafts.utils.cache.CacheBlock;
import com.lightcrafts.utils.cache.FreeBlockManager;
import java.util.ArrayList;
import java.util.Iterator;

public final class CoalescingFreeBlockManager
implements FreeBlockManager {
    private final ArrayList<CacheBlock> m_freeBlockList = new ArrayList();

    @Override
    public synchronized void clear() {
        this.m_freeBlockList.clear();
    }

    @Override
    public synchronized CacheBlock findBlockOfSize(int objSize) {
        if (!this.m_freeBlockList.isEmpty()) {
            Iterator<CacheBlock> i = this.m_freeBlockList.iterator();
            while (i.hasNext()) {
                CacheBlock block = i.next();
                int blockSize = block.getSize();
                if (blockSize == objSize) {
                    i.remove();
                    return block;
                }
                if (blockSize <= objSize) continue;
                long blockPos = block.getPosition();
                block.setPosition(blockPos + (long)objSize);
                block.setSize(blockSize - objSize);
                return new CacheBlock(blockPos, objSize);
            }
        }
        return null;
    }

    @Override
    public synchronized void freeBlock(CacheBlock freeBlock) {
        if (this.m_freeBlockList.isEmpty()) {
            this.m_freeBlockList.add(freeBlock);
            return;
        }
        long freePos = freeBlock.getPosition();
        int freeSize = freeBlock.getSize();
        int index = 0;
        Iterator<CacheBlock> i = this.m_freeBlockList.iterator();
        while (i.hasNext()) {
            int blockSize;
            CacheBlock block = i.next();
            long blockPos = block.getPosition();
            if (blockPos + (long)(blockSize = block.getSize()) == freePos) {
                CacheBlock nextBlock;
                block.setSize(freeSize += blockSize);
                if (i.hasNext() && blockPos + (long)freeSize == (nextBlock = i.next()).getPosition()) {
                    block.setSize(freeSize + nextBlock.getSize());
                    i.remove();
                }
                return;
            }
            if (freePos + (long)freeSize == blockPos) {
                block.setPosition(freePos);
                block.setSize(blockSize + freeSize);
                return;
            }
            if (freePos > blockPos) break;
            ++index;
        }
        this.m_freeBlockList.add(index, freeBlock);
    }
}

