/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.cache;

import com.lightcrafts.utils.bytebuffer.ByteBufferAllocator;
import com.lightcrafts.utils.cache.Cache;
import com.lightcrafts.utils.cache.CacheIOException;
import com.lightcrafts.utils.cache.CacheObjectBroker;
import com.lightcrafts.utils.cache.CacheObjectMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class LRUCacheObjectMap
implements CacheObjectMap {
    private ByteBufferAllocator m_bufAlloc;
    private Cache m_cache;
    private long m_curSize;
    private final Map<Object, ByteBuffer> m_lruMap;
    private final long m_maxSize;

    public LRUCacheObjectMap(ByteBufferAllocator bufAlloc, long maxSize) {
        this(bufAlloc, maxSize, 16, 0.75f);
    }

    public LRUCacheObjectMap(ByteBufferAllocator bufAlloc, long maxSize, int initialCapacity, float loadFactor) {
        this.m_bufAlloc = bufAlloc;
        this.m_lruMap = new LRUHashMap(initialCapacity, loadFactor);
        this.m_maxSize = maxSize;
    }

    @Override
    public synchronized void clear() {
        this.m_bufAlloc.clear();
        this.m_lruMap.clear();
    }

    @Override
    public synchronized boolean contains(Object key) {
        return this.m_lruMap.containsKey(key) || this.m_cache.storeContains(key);
    }

    @Override
    public synchronized void dispose() {
        if (this.m_bufAlloc != null) {
            this.m_bufAlloc.dispose();
            this.m_bufAlloc = null;
        }
        this.m_lruMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getOnce(Object key, Object aux) throws IOException {
        ByteBuffer buf;
        if (key == null) {
            throw new IllegalArgumentException();
        }
        LRUCacheObjectMap lRUCacheObjectMap = this;
        synchronized (lRUCacheObjectMap) {
            buf = this.m_lruMap.remove(key);
        }
        if (buf != null) {
            CacheObjectBroker broker = this.m_cache.getCacheObjectBroker();
            buf.position(0);
            return broker.decodeFromByteBuffer(buf, aux);
        }
        return this.m_cache.readFromStore(key, aux);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Object key, Object obj) {
        ByteBuffer buf;
        if (key == null || obj == null) {
            throw new IllegalArgumentException();
        }
        CacheObjectBroker broker = this.m_cache.getCacheObjectBroker();
        int objSize = broker.getEncodedSizeOf(obj);
        while (true) {
            try {
                buf = this.m_bufAlloc.allocByteBuffer(objSize);
            }
            catch (OutOfMemoryError e) {
                if (this.spillOneObject()) continue;
                throw e;
            }
            break;
        }
        broker.encodeToByteBuffer(buf, obj);
        LRUCacheObjectMap lRUCacheObjectMap = this;
        synchronized (lRUCacheObjectMap) {
            this.m_lruMap.put(key, buf);
            this.m_curSize += (long)objSize;
        }
    }

    @Override
    public synchronized boolean remove(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        ByteBuffer buf = this.m_lruMap.remove(key);
        if (buf != null) {
            this.m_curSize -= (long)buf.limit();
            boolean freed = this.m_bufAlloc.freeByteBuffer(buf);
            assert (freed);
            return true;
        }
        return this.m_cache.removeFromStore(key);
    }

    @Override
    public void setCache(Cache cache) {
        this.m_cache = cache;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private void spill(Object key, ByteBuffer buf) {
        try {
            this.m_cache.writeToStore(key, buf);
        }
        catch (IOException e) {
            throw new CacheIOException(e);
        }
        this.m_curSize -= (long)buf.limit();
        boolean freed = this.m_bufAlloc.freeByteBuffer(buf);
        assert (freed);
    }

    private synchronized boolean spillOneObject() {
        Iterator<Map.Entry<Object, ByteBuffer>> i = this.m_lruMap.entrySet().iterator();
        if (i.hasNext()) {
            Map.Entry<Object, ByteBuffer> me = i.next();
            this.spill(me.getKey(), me.getValue());
            i.remove();
            return true;
        }
        return false;
    }

    private final class LRUHashMap
    extends LinkedHashMap<Object, ByteBuffer> {
        LRUHashMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean removeEldestEntry(Map.Entry notUsed) {
            LRUCacheObjectMap lRUCacheObjectMap = LRUCacheObjectMap.this;
            synchronized (lRUCacheObjectMap) {
                if (LRUCacheObjectMap.this.m_curSize <= LRUCacheObjectMap.this.m_maxSize) {
                    return false;
                }
                Iterator i = this.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry me = i.next();
                    LRUCacheObjectMap.this.spill(me.getKey(), (ByteBuffer)me.getValue());
                    i.remove();
                    if (LRUCacheObjectMap.this.m_curSize > LRUCacheObjectMap.this.m_maxSize) continue;
                    break;
                }
            }
            return false;
        }
    }
}

