/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.cache;

import com.lightcrafts.utils.bytebuffer.ByteBufferAllocator;
import com.lightcrafts.utils.cache.CacheBlock;
import com.lightcrafts.utils.cache.CoalescingFreeBlockManager;
import com.lightcrafts.utils.cache.FreeBlockManager;
import com.lightcrafts.utils.cache.NativeChunk;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public final class NativeByteBufferAllocator
implements ByteBufferAllocator {
    private final Map<Long, CacheBlock> m_allocdBlocks;
    private final Map<Long, FreeBlockManager> m_allocdFBMs;
    private final LinkedList<NativeChunk> m_chunkList = new LinkedList();
    private final int m_chunkSize;
    private final LinkedList<FreeBlockManager> m_freeBlockManagerList;

    public NativeByteBufferAllocator(int chunkSize) {
        this.m_chunkSize = chunkSize;
        this.m_freeBlockManagerList = new LinkedList();
        this.m_allocdBlocks = new HashMap<Long, CacheBlock>();
        this.m_allocdFBMs = new HashMap<Long, FreeBlockManager>();
    }

    @Override
    public synchronized ByteBuffer allocByteBuffer(int size) {
        FreeBlockManager fbm;
        NativeChunk chunk;
        if (size > this.m_chunkSize) {
            throw new IllegalArgumentException("size > chunkSize");
        }
        Iterator c = this.m_chunkList.iterator();
        Iterator f = this.m_freeBlockManagerList.iterator();
        while (c.hasNext()) {
            chunk = (NativeChunk)c.next();
            ByteBuffer buf = this.getByteBuffer(size, chunk, fbm = (FreeBlockManager)f.next());
            if (buf == null) continue;
            return buf;
        }
        this.addChunk();
        chunk = this.m_chunkList.getFirst();
        fbm = this.m_freeBlockManagerList.getFirst();
        return this.getByteBuffer(size, chunk, fbm);
    }

    @Override
    public synchronized void clear() {
        this.dispose();
        this.m_allocdBlocks.clear();
        this.m_allocdFBMs.clear();
        this.m_freeBlockManagerList.clear();
    }

    @Override
    public synchronized void dispose() {
        for (NativeChunk chunk : this.m_chunkList) {
            chunk.dispose();
        }
        this.m_chunkList.clear();
    }

    @Override
    public synchronized boolean freeByteBuffer(ByteBuffer buf) {
        Long bufKey = NativeByteBufferAllocator.getKeyFor(buf);
        CacheBlock block = this.m_allocdBlocks.remove(bufKey);
        FreeBlockManager fbm = this.m_allocdFBMs.remove(bufKey);
        if (block != null && fbm != null) {
            fbm.freeBlock(block);
            return true;
        }
        assert (block == null && fbm == null);
        return false;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private void addChunk() {
        NativeChunk chunk = new NativeChunk(this.m_chunkSize);
        this.m_chunkList.addFirst(chunk);
        CoalescingFreeBlockManager fbm = new CoalescingFreeBlockManager();
        this.m_freeBlockManagerList.addFirst(fbm);
        fbm.freeBlock(new CacheBlock(0L, this.m_chunkSize));
    }

    private ByteBuffer getByteBuffer(int size, NativeChunk chunk, FreeBlockManager fbm) {
        CacheBlock block = fbm.findBlockOfSize(size);
        if (block != null) {
            long addr = chunk.getAddr() + block.getPosition();
            ByteBuffer buf = NativeByteBufferAllocator.getNativeByteBuffer(addr, size);
            buf.order(ByteOrder.nativeOrder());
            Long bufKey = NativeByteBufferAllocator.getKeyFor(buf);
            this.m_allocdBlocks.put(bufKey, block);
            this.m_allocdFBMs.put(bufKey, fbm);
            return buf;
        }
        return null;
    }

    private static Long getKeyFor(ByteBuffer buf) {
        return new Long(NativeByteBufferAllocator.getNativeAddressOf(buf));
    }

    private static native long getNativeAddressOf(ByteBuffer var0);

    private static native ByteBuffer getNativeByteBuffer(long var0, int var2);

    static {
        System.loadLibrary("LCCache");
    }
}

