/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.cache;

public final class NativeChunk {
    private long m_addr;
    private final int m_size;

    public NativeChunk(int size) {
        this.m_addr = NativeChunk.alloc(size);
        if (this.m_addr == 0L) {
            throw new OutOfMemoryError("failed to alloc native chunk");
        }
        this.m_size = size;
    }

    public synchronized void dispose() {
        if (this.m_addr != 0L) {
            NativeChunk.free(this.m_addr, this.m_size);
            this.m_addr = 0L;
        }
    }

    public long getAddr() {
        return this.m_addr;
    }

    public int getSize() {
        return this.m_size;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private static native long alloc(int var0);

    private static native void free(long var0, int var2);

    static {
        System.loadLibrary("LCCache");
    }
}

