/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.filecache;

import com.lightcrafts.utils.file.FileUtil;
import java.io.File;
import java.io.IOException;

final class CacheFile
extends File {
    private final long m_originalLastAccessTime;
    private final long m_originalLength;

    @Override
    public long length() {
        return this.m_originalLength;
    }

    CacheFile(File file) throws IOException {
        this(file, FileUtil.getLastAccessTimeOf(file));
    }

    CacheFile(String pathname) throws IOException {
        super(pathname);
        this.m_originalLastAccessTime = FileUtil.getLastAccessTimeOf(this);
        this.m_originalLength = super.length();
    }

    CacheFile(File file, long lastAccessTime) {
        this(file.getAbsolutePath(), lastAccessTime);
    }

    CacheFile(String pathname, long lastAccessTime) {
        super(pathname);
        this.m_originalLastAccessTime = lastAccessTime;
        this.m_originalLength = super.length();
    }

    long lastAccessTime() {
        return this.m_originalLastAccessTime;
    }
}

